/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.web;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.dmz.discovery.DiscoverableFeature;
import com.atlassian.bitbucket.dmz.discovery.FeatureDiscoveryService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.plugin.IssueValidationConfigurationService;
import com.atlassian.bitbucket.internal.plugin.model.IssueValidationConfiguration;
import com.atlassian.bitbucket.internal.plugin.rest.RestIssueValidationConfiguration;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

@LicensedOnly
public class JiraCommitCheckerConfigurationServlet
extends HttpServlet {
    private static final String PROJECT_JIRA_COMMIT_CHECKER_SETTINGS = "bitbucketPluginJiraCommitChecker.page.projectSettings.page";
    private static final String REPOSITORY_JIRA_COMMIT_CHECKER_SETTINGS = "bitbucketPluginJiraCommitChecker.page.repositorySettings.page";
    private static final String RESOURCE_KEY = "com.atlassian.bitbucket.server.bitbucket-jira-commit-checker:page-templates";
    private static final Pattern projectUrl = Pattern.compile("^/projects/[^/]+$");
    private static final Pattern repoUrl = Pattern.compile("^/projects/.+/repos/[^/]+$");
    private final AvatarEnricher avatarEnricher;
    private final IssueValidationConfigurationService configurationService;
    private final FeatureDiscoveryService featureDiscoveryService;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final ProjectService projectService;
    private final RepositoryService repositoryService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public JiraCommitCheckerConfigurationServlet(AvatarEnricher avatarEnricher, IssueValidationConfigurationService configurationService, FeatureDiscoveryService featureDiscoveryService, FeatureManager featureManager, I18nService i18nService, PermissionService permissionService, ProjectService projectService, RepositoryService repositoryService, SoyTemplateRenderer soyTemplateRenderer) {
        this.avatarEnricher = avatarEnricher;
        this.configurationService = configurationService;
        this.featureDiscoveryService = featureDiscoveryService;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String templateKey;
        if (!this.featureManager.isEnabled((Feature)StandardFeature.JIRA_COMMIT_CHECKER)) {
            resp.sendError(401, this.i18nService.getMessage("bitbucket.jira.commit.checker.web.feature.unavailable", new Object[0]));
            return;
        }
        Optional<Scope> optionalScope = this.getScope(req.getPathInfo());
        if (!optionalScope.isPresent()) {
            resp.sendError(404);
            return;
        }
        Scope scope = optionalScope.get();
        ImmutableMap.Builder initialData = ImmutableMap.builder();
        if (scope instanceof ProjectScope) {
            Project project = ((ProjectScope)scope).getProject();
            if (!this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
                resp.sendError(401, this.i18nService.getMessage("bitbucket.jira.commit.checker.web.project.settings.no.permission", new Object[0]));
                return;
            }
            templateKey = PROJECT_JIRA_COMMIT_CHECKER_SETTINGS;
            initialData.put((Object)"project", (Object)project).put((Object)"scopeType", (Object)scope.getType().name());
        } else if (scope instanceof RepositoryScope) {
            Repository repository = ((RepositoryScope)scope).getRepository();
            if (!this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN)) {
                resp.sendError(401, this.i18nService.getMessage("bitbucket.jira.commit.checker.web.repository.settings.no.permission", new Object[0]));
                return;
            }
            this.configurationService.getConfiguration((Scope)Scopes.project((Project)repository.getProject())).ifPresent(config -> initialData.put((Object)"inheritedConfig", (Object)this.toRestConfig((IssueValidationConfiguration)config, req.isSecure())));
            templateKey = REPOSITORY_JIRA_COMMIT_CHECKER_SETTINGS;
            initialData.put((Object)"repository", (Object)repository).put((Object)"project", (Object)repository.getProject()).put((Object)"scopeType", (Object)scope.getType().name());
        } else {
            resp.sendError(404);
            return;
        }
        this.configurationService.getConfiguration(scope).ifPresent(config -> initialData.put((Object)"config", (Object)this.toRestConfig((IssueValidationConfiguration)config, req.isSecure())));
        this.featureDiscoveryService.setDiscovered(EnumSet.of(DiscoverableFeature.JIRA_COMMIT_CHECKER));
        this.render(resp, templateKey, (Map<String, Object>)initialData.build());
    }

    private Optional<Scope> getScope(String pathInfo) {
        if (Strings.isNullOrEmpty((String)pathInfo)) {
            return Optional.empty();
        }
        if (!projectUrl.matcher(pathInfo).matches() && !repoUrl.matcher(pathInfo).matches()) {
            return Optional.empty();
        }
        String[] pathParts = pathInfo.substring(1).split("/");
        switch (pathParts.length) {
            case 2: {
                return Optional.ofNullable(this.projectService.getByKey(pathParts[1])).map(Scopes::project);
            }
            case 4: {
                return Optional.ofNullable(this.repositoryService.getBySlug(pathParts[1], pathParts[3])).map(Scopes::repository);
            }
        }
        return Optional.empty();
    }

    private void render(HttpServletResponse resp, String templateName, Map<String, Object> data) throws IOException, ServletException {
        resp.setContentType("text/html;charset=UTF-8");
        try {
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), RESOURCE_KEY, templateName, data);
        }
        catch (SoyException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new ServletException((Throwable)e);
        }
    }

    private RestIssueValidationConfiguration toRestConfig(IssueValidationConfiguration config, boolean secure) {
        RestIssueValidationConfiguration restConfig = new RestIssueValidationConfiguration(config);
        restConfig.getExemptPushers().forEach(user -> this.avatarEnricher.enrich(user, new AvatarRequest(secure, 48)));
        return restConfig;
    }
}

