/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.api;

import com.atlassian.crowd.embedded.api.PasswordPolicyConfigurationPreset;
import com.atlassian.crowd.exception.InvalidCharacterClassConstraintException;
import com.atlassian.crowd.exception.InvalidPasswordPolicyConfigurationException;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.stream.Stream;

public class PasswordPolicyConfiguration {
    private PasswordPolicyConfigurationPreset preset;
    private Integer minimumLength;
    private Integer minimumLowercase;
    private Integer minimumUppercase;
    private Integer minimumDigits;
    private Integer minimumSpecialCharacters;
    private Integer minimumRulesMatched;

    public PasswordPolicyConfiguration() {
    }

    private PasswordPolicyConfiguration(@Nullable PasswordPolicyConfigurationPreset preset, @Nullable Integer minimumLength, @Nullable Integer minimumLowercase, @Nullable Integer minimumUppercase, @Nullable Integer minimumDigits, @Nullable Integer minimumSpecialCharacters, @Nullable Integer minimumRulesMatched) throws InvalidPasswordPolicyConfigurationException {
        this.preset = preset;
        this.minimumLength = minimumLength;
        this.minimumLowercase = minimumLowercase;
        this.minimumUppercase = minimumUppercase;
        this.minimumDigits = minimumDigits;
        this.minimumSpecialCharacters = minimumSpecialCharacters;
        this.minimumRulesMatched = minimumRulesMatched;
        long ruleCount = Stream.of(minimumLowercase, minimumUppercase, minimumDigits, minimumSpecialCharacters).filter(Objects::nonNull).count();
        if (minimumRulesMatched != null && (long)minimumRulesMatched.intValue() > ruleCount) {
            throw new InvalidCharacterClassConstraintException(String.format("Number of rules to be matched: {%d} is greater than total number of rules: {%d}", minimumRulesMatched, ruleCount));
        }
    }

    public PasswordPolicyConfigurationPreset getPreset() {
        return this.preset;
    }

    public Integer getMinimumLength() {
        return this.minimumLength;
    }

    public Integer getMinimumLowercase() {
        return this.minimumLowercase;
    }

    public Integer getMinimumUppercase() {
        return this.minimumUppercase;
    }

    public Integer getMinimumDigits() {
        return this.minimumDigits;
    }

    public Integer getMinimumSpecialCharacters() {
        return this.minimumSpecialCharacters;
    }

    public Integer getMinimumRulesMatched() {
        return this.minimumRulesMatched;
    }

    public void setPreset(PasswordPolicyConfigurationPreset preset) {
        this.preset = preset;
    }

    public void setMinimumLength(Integer minimumLength) {
        this.minimumLength = minimumLength;
    }

    public void setMinimumLowercase(Integer minimumLowercase) {
        this.minimumLowercase = minimumLowercase;
    }

    public void setMinimumUppercase(Integer minimumUppercase) {
        this.minimumUppercase = minimumUppercase;
    }

    public void setMinimumDigits(Integer minimumDigits) {
        this.minimumDigits = minimumDigits;
    }

    public void setMinimumSpecialCharacters(Integer minimumSpecialCharacters) {
        this.minimumSpecialCharacters = minimumSpecialCharacters;
    }

    public void setMinimumRulesMatched(Integer minimumRulesMatched) {
        this.minimumRulesMatched = minimumRulesMatched;
    }

    public static PasswordPolicyConfigurationBuilder builder() {
        return new PasswordPolicyConfigurationBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PasswordPolicyConfiguration that = (PasswordPolicyConfiguration)o;
        return this.preset == that.preset && Objects.equals(this.minimumLength, that.minimumLength) && Objects.equals(this.minimumLowercase, that.minimumLowercase) && Objects.equals(this.minimumUppercase, that.minimumUppercase) && Objects.equals(this.minimumDigits, that.minimumDigits) && Objects.equals(this.minimumSpecialCharacters, that.minimumSpecialCharacters) && Objects.equals(this.minimumRulesMatched, that.minimumRulesMatched);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.preset, this.minimumLength, this.minimumLowercase, this.minimumUppercase, this.minimumDigits, this.minimumSpecialCharacters, this.minimumRulesMatched});
    }

    public static final class PasswordPolicyConfigurationBuilder {
        private PasswordPolicyConfigurationPreset preset;
        private Integer minimumLength;
        private Integer minimumLowercase;
        private Integer minimumUppercase;
        private Integer minimumDigits;
        private Integer minimumSpecialCharacters;
        private Integer minimumRulesMatched;

        public PasswordPolicyConfigurationBuilder preset(PasswordPolicyConfigurationPreset preset) {
            this.preset = preset;
            return this;
        }

        public PasswordPolicyConfigurationBuilder minimumLength(Integer minimumLength) {
            this.minimumLength = minimumLength;
            return this;
        }

        public PasswordPolicyConfigurationBuilder minimumLength(String minimumLengthString) {
            this.minimumLength = this.intOrNull(minimumLengthString);
            return this;
        }

        public PasswordPolicyConfigurationBuilder minimumLowercase(Integer minimumLowercase) {
            this.minimumLowercase = minimumLowercase;
            return this;
        }

        public PasswordPolicyConfigurationBuilder minimumLowercase(String minimumLowercaseString) {
            this.minimumLowercase = this.intOrNull(minimumLowercaseString);
            return this;
        }

        public PasswordPolicyConfigurationBuilder minimumUppercase(Integer minimumUppercase) {
            this.minimumUppercase = minimumUppercase;
            return this;
        }

        public PasswordPolicyConfigurationBuilder minimumUppercase(String minimumUppercaseString) {
            this.minimumUppercase = this.intOrNull(minimumUppercaseString);
            return this;
        }

        public PasswordPolicyConfigurationBuilder minimumDigits(Integer minimumDigits) {
            this.minimumDigits = minimumDigits;
            return this;
        }

        public PasswordPolicyConfigurationBuilder minimumDigits(String minimumDigitsString) {
            this.minimumDigits = this.intOrNull(minimumDigitsString);
            return this;
        }

        public PasswordPolicyConfigurationBuilder minimumSpecialCharacters(Integer minimumSpecialCharacters) {
            this.minimumSpecialCharacters = minimumSpecialCharacters;
            return this;
        }

        public PasswordPolicyConfigurationBuilder minimumSpecialCharacters(String minimumSpecialCharactersString) {
            this.minimumSpecialCharacters = this.intOrNull(minimumSpecialCharactersString);
            return this;
        }

        public PasswordPolicyConfigurationBuilder minimumRulesMatched(Integer minimumRulesMatched) {
            this.minimumRulesMatched = minimumRulesMatched;
            return this;
        }

        public PasswordPolicyConfigurationBuilder minimumRulesMatched(String minimumRulesMatchedString) {
            this.minimumRulesMatched = this.intOrNull(minimumRulesMatchedString);
            return this;
        }

        public PasswordPolicyConfiguration build() {
            return new PasswordPolicyConfiguration(this.preset, this.minimumLength, this.minimumLowercase, this.minimumUppercase, this.minimumDigits, this.minimumSpecialCharacters, this.minimumRulesMatched);
        }

        private Integer intOrNull(String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

