/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.rest.entity;

import com.atlassian.crowd.integration.rest.entity.ValidationFactorEntity;
import com.atlassian.crowd.integration.rest.entity.ValidationFactorEntityList;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@XmlRootElement(name="authentication-context")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AuthenticationContextEntity {
    @XmlElement(name="username")
    private final String username;
    @XmlElement(name="password")
    private final String password;
    @XmlElement(name="validation-factors")
    private final ValidationFactorEntityList validationFactors;

    private AuthenticationContextEntity() {
        this.username = null;
        this.password = null;
        this.validationFactors = null;
    }

    public AuthenticationContextEntity(String name, String password, ValidationFactorEntityList validationFactors) {
        this.username = name;
        this.password = password;
        this.validationFactors = validationFactors;
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<ValidationFactorEntity> getValidationFactors() {
        if (this.validationFactors != null) {
            return this.validationFactors.getValidationFactors();
        }
        return Collections.emptyList();
    }

    public static AuthenticationContextEntity newInstance(UserAuthenticationContext uac) {
        ValidationFactorEntityList validationFactorEntityList = ValidationFactorEntityList.newInstance(Arrays.asList(uac.getValidationFactors()));
        if (uac.getCredential() != null) {
            return new AuthenticationContextEntity(uac.getName(), uac.getCredential().getCredential(), validationFactorEntityList);
        }
        return new AuthenticationContextEntity(uac.getName(), null, validationFactorEntityList);
    }
}

