/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public class CanMergePullRequestCondition
implements Condition {
    public static final String REPOSITORY = "repository";
    protected final PermissionService permissionService;

    public CanMergePullRequestCondition(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.hasPermission(context);
    }

    protected boolean hasPermission(Map<String, Object> context) {
        Repository repository = (Repository)context.get(REPOSITORY);
        return this.permissionService.hasRepositoryPermission(repository, Permission.REPO_WRITE);
    }
}

