/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.webresource.spi.condition.AbstractBooleanUrlReadingCondition;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HasGlobalPermissionUrlReadingCondition
extends AbstractBooleanUrlReadingCondition {
    private static final String PERMISSION = "permission";
    private final PermissionService permissionService;
    private Permission permission;

    public HasGlobalPermissionUrlReadingCondition(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        String permissionName = params.get(PERMISSION);
        if (StringUtils.isBlank((CharSequence)permissionName)) {
            throw new PluginParseException(((Object)((Object)this)).getClass().getSimpleName() + ": The [permission] param is required, and must define a global permission");
        }
        try {
            this.permission = Permission.valueOf((String)permissionName);
            Preconditions.checkArgument((boolean)this.permission.isGlobal(), (String)"%s requires a global permission", (Object)((Object)((Object)this)).getClass().getSimpleName());
        }
        catch (IllegalArgumentException e) {
            throw new PluginParseException(e.getMessage());
        }
    }

    protected boolean isConditionTrue() {
        return this.permissionService.hasGlobalPermission(this.permission);
    }

    protected String queryKey() {
        return String.format("has%sPermission", this.permission.name());
    }
}

