/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.project.AbstractProjectVisitor;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserEquality;
import com.atlassian.plugin.web.Condition;
import jakarta.annotation.Nonnull;
import java.util.Map;

public class IsPersonalRepositoryCondition
implements Condition {
    public static final String REPOSITORY = "repository";
    public static final String ONLY_MINE = "onlyMine";
    private final AuthenticationContext authenticationContext;
    private boolean onlyMine;

    public IsPersonalRepositoryCondition(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> params) {
        this.onlyMine = Boolean.parseBoolean(params.get(ONLY_MINE));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Repository repository = (Repository)context.get(REPOSITORY);
        if (repository == null) {
            return false;
        }
        return (Boolean)repository.getProject().accept((ProjectVisitor)new AbstractProjectVisitor<Boolean>(Boolean.FALSE){

            public Boolean visit(@Nonnull PersonalProject project) {
                return !IsPersonalRepositoryCondition.this.onlyMine || ApplicationUserEquality.equals((ApplicationUser)project.getOwner(), (Object)IsPersonalRepositoryCondition.this.authenticationContext.getCurrentUser());
            }
        });
    }
}

