/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public class IsRepositoryForkableCondition
implements Condition {
    public static final String ANONYMOUS_ALLOWED = "anonymousAllowed";
    public static final String REPOSITORY = "repository";
    private final AuthenticationContext authenticationContext;
    private boolean anonymousAllowed;

    public IsRepositoryForkableCondition(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> params) {
        this.anonymousAllowed = Boolean.parseBoolean(params.get(ANONYMOUS_ALLOWED));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        if (!this.anonymousAllowed && !this.authenticationContext.isAuthenticated()) {
            return false;
        }
        Repository repository = (Repository)context.get(REPOSITORY);
        return repository != null && repository.isForkable();
    }
}

