/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.branch.model;

import com.atlassian.bitbucket.branch.model.BranchType;
import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Predicate;

public enum BranchTypes {
    BUGFIX,
    FEATURE,
    HOTFIX,
    RELEASE;

    public static final Ordering<BranchType> DEFAULT_ORDER;

    public static BranchTypes forId(@Nonnull String id) {
        return BranchTypes.valueOf(Objects.requireNonNull(id, "id").toUpperCase());
    }

    public String getId() {
        return this.name();
    }

    public Predicate<BranchType> matcher() {
        return branchType -> branchType != null && this.getId().equals(branchType.getId().toUpperCase());
    }

    static {
        DEFAULT_ORDER = Ordering.natural().onResultOf((Function)new Function<BranchType, BranchTypes>(){

            public BranchTypes apply(BranchType type) {
                return BranchTypes.forId(type.getId());
            }
        });
    }
}

