/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.branch.model.configuration;

import com.atlassian.bitbucket.branch.model.BranchTypes;
import com.atlassian.bitbucket.branch.model.configuration.BranchConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchTypeConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.SimpleBranchTypeConfiguration;
import com.atlassian.bitbucket.scope.Scope;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class BranchModelConfigurationRequest
implements BranchModelConfiguration {
    private final BranchConfiguration development;
    private final BranchConfiguration production;
    private final Scope scope;
    private final Set<BranchTypeConfiguration> types;

    private BranchModelConfigurationRequest(Builder builder) {
        this.development = new InternalBranchConfiguration(builder.developmentRefId, builder.useDefaultAsDevelopment);
        this.production = BranchModelConfigurationRequest.createProductionConfiguration(builder);
        this.scope = builder.scope;
        this.types = ImmutableSet.copyOf(builder.types.values());
    }

    @Override
    @Nonnull
    public BranchConfiguration getDevelopment() {
        return this.development;
    }

    @Override
    @Nullable
    public BranchConfiguration getProduction() {
        return this.production;
    }

    @Override
    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    @Override
    @Nonnull
    public Set<BranchTypeConfiguration> getTypes() {
        return this.types;
    }

    private static BranchConfiguration createProductionConfiguration(Builder builder) {
        if (StringUtils.isNotEmpty((CharSequence)builder.productionRefId) || builder.useDefaultAsProduction) {
            return new InternalBranchConfiguration(builder.productionRefId, builder.useDefaultAsProduction);
        }
        return null;
    }

    private static Map<BranchTypes, BranchTypeConfiguration> toTypeMap(Set<BranchTypeConfiguration> types) {
        EnumMap result = Maps.newEnumMap(BranchTypes.class);
        for (BranchTypeConfiguration config : types) {
            result.put(BranchTypes.forId(config.getId()), config);
        }
        return result;
    }

    private static class InternalBranchConfiguration
    implements BranchConfiguration {
        private final String refId;
        private final boolean useDefaultBranch;

        public InternalBranchConfiguration(String refId, boolean useDefaultBranch) {
            this.refId = refId;
            this.useDefaultBranch = useDefaultBranch;
        }

        @Override
        @Nullable
        public String getRefId() {
            return this.refId;
        }

        @Override
        public boolean isUseDefault() {
            return this.useDefaultBranch;
        }
    }

    public static class Builder {
        private String developmentRefId;
        private boolean useDefaultAsDevelopment;
        private String productionRefId;
        private Scope scope;
        private boolean useDefaultAsProduction;
        private Map<BranchTypes, BranchTypeConfiguration> types = Maps.newEnumMap(BranchTypes.class);

        public Builder(@Nonnull Scope scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
        }

        public Builder(@Nonnull BranchModelConfiguration configuration) {
            this.developmentRefId = configuration.getDevelopment().getRefId();
            this.useDefaultAsDevelopment = configuration.getDevelopment().isUseDefault();
            if (configuration.getProduction() != null) {
                this.productionRefId = configuration.getProduction().getRefId();
                this.useDefaultAsProduction = configuration.getProduction().isUseDefault();
            }
            this.scope = configuration.getScope();
            this.types = BranchModelConfigurationRequest.toTypeMap(configuration.getTypes());
        }

        @Nonnull
        public Builder developmentRefId(@Nullable String developmentRefId) {
            this.developmentRefId = developmentRefId;
            return this;
        }

        @Nonnull
        public Builder enabledType(@Nonnull String id, @Nonnull String prefix) {
            return this.type(id, prefix, true);
        }

        @Nonnull
        public Builder useDefaultAsDevelopment(boolean useDefault) {
            this.useDefaultAsDevelopment = useDefault;
            return this;
        }

        @Nonnull
        public Builder productionRefId(@Nullable String productionRefId) {
            this.productionRefId = productionRefId;
            return this;
        }

        @Nonnull
        public Builder scope(@Nonnull Scope scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            return this;
        }

        @Nonnull
        public Builder type(@Nonnull String id, @Nullable String prefix, boolean enabled) {
            Objects.requireNonNull(id, "id");
            BranchTypes type = BranchTypes.forId(id);
            this.types.put(type, new SimpleBranchTypeConfiguration(type, enabled, prefix));
            return this;
        }

        @Nonnull
        public Builder useDefaultAsProduction(boolean useDefault) {
            this.useDefaultAsProduction = useDefault;
            return this;
        }

        @Nonnull
        public BranchModelConfigurationRequest build() {
            return new BranchModelConfigurationRequest(this);
        }
    }
}

