/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch;

import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestrictionService;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class BranchRestrictionScopeHelper {
    private final I18nService i18nService;
    private final DmzProjectSettingsRestrictionService projectSettingsRestrictionService;

    public BranchRestrictionScopeHelper(I18nService i18nService, DmzProjectSettingsRestrictionService projectSettingsRestrictionService) {
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
        this.i18nService = i18nService;
    }

    public Scope getUnrestrictedScope(Scope scope) {
        return (Scope)scope.accept((ScopeVisitor)new ScopeVisitor<Scope>(){

            public Scope visit(@Nonnull ProjectScope scope) {
                return scope;
            }

            public Scope visit(@Nonnull RepositoryScope scope) {
                if (BranchRestrictionScopeHelper.this.projectSettingsRestrictionService.hasRestrictionUnsecured(scope.getProject(), ProjectSettingsRestrictionKeys.BRANCH_MODEL)) {
                    return Scopes.project((Project)scope.getProject());
                }
                return scope;
            }
        });
    }

    public void validateNotRestricted(Scope scope, final String errorKey) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                if (BranchRestrictionScopeHelper.this.projectSettingsRestrictionService.hasRestrictionUnsecured(scope.getProject(), ProjectSettingsRestrictionKeys.BRANCH_MODEL)) {
                    throw new ForbiddenException(BranchRestrictionScopeHelper.this.i18nService.createKeyedMessage(errorKey, new Object[0]));
                }
                return null;
            }
        });
    }

    public static void validateScopeType(Scope scope, String errorMessage) {
        Objects.requireNonNull(scope, "scope");
        if (scope.getType() != ScopeType.PROJECT && scope.getType() != ScopeType.REPOSITORY) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

