/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch;

import com.atlassian.bitbucket.event.branch.BranchDeletedEvent;
import com.atlassian.bitbucket.event.branch.BranchDeletionHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookVetoedException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.branch.BranchHasMovedException;
import com.atlassian.bitbucket.internal.branch.InternalBranchService;
import com.atlassian.bitbucket.internal.branch.UnsupportedOnBranchException;
import com.atlassian.bitbucket.internal.branch.info.BranchInfoRequest;
import com.atlassian.bitbucket.internal.branch.info.BranchInformation;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.PullRequestDirection;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.CreateBranchRequest;
import com.atlassian.bitbucket.repository.IllegalRepositoryStateException;
import com.atlassian.bitbucket.repository.InvalidRefNameException;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.SimpleBranch;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.ProcessFailedException;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.updateref.GitUpdateRefDeleteBuilder;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBranchService
implements InternalBranchService {
    @VisibleForTesting
    static final String PROPERTY_MAX_BRANCHES = "plugin.bitbucket-branch-information.max.branches";
    private static final Logger log = LoggerFactory.getLogger(DefaultBranchService.class);
    private final BranchInformation branchInfo;
    private final GitCommandBuilderFactory builderFactory;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final PullRequestService pullRequestService;
    private final RefService refService;
    private final RepositoryHookService repositoryHookService;
    private final int maxBranches;

    public DefaultBranchService(BranchInformation branchInfo, GitCommandBuilderFactory builderFactory, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, ApplicationPropertiesService propertiesService, PullRequestService pullRequestService, RefService refService, RepositoryHookService repositoryHookService) {
        this.branchInfo = branchInfo;
        this.builderFactory = builderFactory;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.pullRequestService = pullRequestService;
        this.refService = refService;
        this.repositoryHookService = repositoryHookService;
        this.maxBranches = propertiesService.getPluginProperty(PROPERTY_MAX_BRANCHES, 10);
    }

    @Override
    @Nonnull
    public Branch createBranch(@Nonnull Repository repository, @Nonnull String branchName, @Nonnull String startPoint) {
        Branch branch = this.refService.createBranch(new CreateBranchRequest.Builder(repository, branchName, startPoint).build());
        log.debug("{}: Created branch {}", (Object)repository, (Object)branchName);
        return branch;
    }

    @Override
    public void deleteBranch(@Nonnull Repository repository, @Nonnull String branchName, @Nullable String endPoint, boolean dryRun) {
        this.validateNonBlankBranchName(branchName);
        this.validateIsGitRepo(repository);
        Branch branch = (Branch)this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(branchName).type((RefType)StandardRefType.BRANCH).build());
        if (branch != null) {
            this.validateCanDeleteBranch(repository, branch, endPoint);
            BranchDeletionHookRequest hookRequest = ((BranchDeletionHookRequest.Builder)new BranchDeletionHookRequest.Builder(repository, branch).dryRun(dryRun)).build();
            RepositoryHookResult result = this.repositoryHookService.preUpdate((RepositoryHookRequest)hookRequest);
            if (result.isRejected()) {
                throw new RepositoryHookVetoedException(this.i18nService.createKeyedMessage("bitbucket.branch.deletion.canceled", new Object[]{branch.getDisplayId()}), (RepositoryHookRequest)hookRequest, result.getVetoes());
            }
            if (!dryRun) {
                this.actuallyDeleteBranch(repository, branch, endPoint);
            }
        }
    }

    @Override
    @Nonnull
    public Page<Branch> findByCommit(@Nonnull Repository repository, @Nonnull String commit, @Nonnull PageRequest pageRequest) {
        Branch defaultBranch;
        PageRequest restrictedRequest = pageRequest.buildRestrictedPageRequest(this.maxBranches);
        Page<MinimalRef> branches = this.getBranches(repository, commit, restrictedRequest, Collections.singletonList(defaultBranch = this.refService.getDefaultBranch(repository)));
        if (branches.getSize() == 0) {
            branches = this.getBranches(repository, commit, restrictedRequest, Collections.emptyList());
        }
        return branches.transform(ref -> ((SimpleBranch.Builder)((SimpleBranch.Builder)((SimpleBranch.Builder)new SimpleBranch.Builder().id(ref.getId())).displayId(ref.getDisplayId())).isDefault(Objects.equals(ref.getId(), defaultBranch.getId()))).build());
    }

    private Page<MinimalRef> getBranches(Repository repository, String commit, PageRequest pageRequest, List<MinimalRef> branches) {
        return this.branchInfo.getBranches(new BranchInfoRequest(repository, commit, pageRequest, branches));
    }

    private void validateCanDeleteBranch(Repository repository, Branch branch, String endPoint) {
        if (branch.getIsDefault()) {
            throw new UnsupportedOnBranchException(this.i18nService.createKeyedMessage("bitbucket.branch.deletion.default.branch", new Object[]{branch.getDisplayId()}));
        }
        if (endPoint != null && !endPoint.equals(branch.getLatestCommit())) {
            throw this.branchHasMoved();
        }
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_WRITE);
        this.validateForOpenPullRequests(repository, branch);
    }

    private void actuallyDeleteBranch(Repository repository, Branch branch, String endPoint) {
        block2: {
            GitUpdateRefDeleteBuilder delete = (GitUpdateRefDeleteBuilder)this.builderFactory.builder(repository).updateRef().delete(branch.getId()).oldValue(endPoint);
            try {
                delete.build().call();
            }
            catch (ProcessFailedException e) {
                if (!e.getMessage().contains("but expected")) break block2;
                throw this.branchHasMoved();
            }
        }
        log.info("{}: Deleted branch {}", (Object)repository, (Object)branch);
        this.eventPublisher.publish((Object)new BranchDeletedEvent((Object)this, repository, branch));
    }

    private BranchHasMovedException branchHasMoved() {
        return new BranchHasMovedException(this.i18nService.createKeyedMessage("bitbucket.branch.deletion.branch.moved", new Object[0]));
    }

    private void validateNonBlankBranchName(String branchName) {
        if (StringUtils.isBlank((CharSequence)branchName)) {
            throw new InvalidRefNameException(this.i18nService.createKeyedMessage("bitbucket.branch.creation.name.empty", new Object[0]), "");
        }
    }

    private void validateIsGitRepo(Repository repository) {
        if (!"git".equals(repository.getScmId())) {
            throw new IllegalRepositoryStateException(this.i18nService.createKeyedMessage("bitbucket.branch.creation.nongit", new Object[]{repository.getScmId()}));
        }
    }

    private void validateForOpenPullRequests(Repository repository, Branch branch) {
        if (this.hasOpenPullRequests(repository, branch, PullRequestDirection.OUTGOING) || this.hasOpenPullRequests(repository, branch, PullRequestDirection.INCOMING)) {
            throw new UnsupportedOnBranchException(this.i18nService.createKeyedMessage("bitbucket.branch.deletion.open.pull.requests", new Object[0]));
        }
    }

    private boolean hasOpenPullRequests(Repository repository, Branch branch, PullRequestDirection direction) {
        Page page = this.pullRequestService.search(new PullRequestSearchRequest.Builder().repositoryAndBranch(direction, Integer.valueOf(repository.getId()), branch.getId()).state(PullRequestState.OPEN).withProperties(false).build(), PageUtils.newRequest((int)0, (int)1));
        return page.getSize() > 0;
    }
}

