/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.branch.ScopeValidationService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import jakarta.annotation.Nonnull;

public class DefaultScopeValidationService
implements ScopeValidationService {
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;

    public DefaultScopeValidationService(I18nService i18nService, PermissionValidationService permissionValidationService) {
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
    }

    @Override
    public void validateReadPermission(@Nonnull Scope scope, final String globalErrorKey) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull GlobalScope globalScope) {
                throw new UnsupportedOperationException(DefaultScopeValidationService.this.i18nService.getMessage(globalErrorKey, new Object[0]));
            }

            public Void visit(@Nonnull ProjectScope projectScope) {
                DefaultScopeValidationService.this.permissionValidationService.validateForProject(projectScope.getProject(), Permission.PROJECT_READ);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                DefaultScopeValidationService.this.permissionValidationService.validateForRepository(repositoryScope.getRepository(), Permission.REPO_READ);
                return null;
            }
        });
    }

    @Override
    public void validateAdminPermission(@Nonnull Scope scope, final String globalErrorKey) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull GlobalScope globalScope) {
                throw new UnsupportedOperationException(DefaultScopeValidationService.this.i18nService.getMessage(globalErrorKey, new Object[0]));
            }

            public Void visit(@Nonnull ProjectScope projectScope) {
                DefaultScopeValidationService.this.permissionValidationService.validateForProject(projectScope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                DefaultScopeValidationService.this.permissionValidationService.validateForRepository(repositoryScope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }
}

