/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitEnricher;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefMetadataContext;
import com.atlassian.bitbucket.repository.RefMetadataProvider;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatestCommitMetadataProvider
implements RefMetadataProvider<Commit> {
    private static final Logger log = LoggerFactory.getLogger(LatestCommitMetadataProvider.class);
    private final CommitEnricher commitEnricher;
    private final ScmService scmService;

    public LatestCommitMetadataProvider(CommitEnricher commitEnricher, ScmService scmService) {
        this.commitEnricher = commitEnricher;
        this.scmService = scmService;
    }

    @Nonnull
    public Map<Ref, Commit> getMetadata(@Nonnull RefMetadataContext context) {
        Repository repository = context.getRepository();
        Page commits = (Page)this.scmService.getCommandFactory(repository).commits(this.buildParameters(context), PageUtils.newRequest((int)0, (int)context.getRefs().size())).call();
        if (commits == null) {
            return Collections.emptyMap();
        }
        ImmutableMap commitById = Maps.uniqueIndex((Iterable)this.enrichCommits(repository, (Page<Commit>)commits).getValues(), MinimalCommit::getId);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Ref ref : context.getRefs()) {
            Commit commit = (Commit)commitById.get(ref.getLatestCommit());
            if (commit == null) {
                log.warn("{}: Missing commit {} for ref {}", new Object[]{repository, ref.getLatestCommit(), ref.getId()});
                continue;
            }
            builder.put((Object)ref, (Object)commit);
        }
        return builder.build();
    }

    private CommitsCommandParameters buildParameters(RefMetadataContext metadataContext) {
        Map context = metadataContext.getContext();
        CommitsCommandParameters.Builder builder = new CommitsCommandParameters.Builder().include((Iterable)Collections2.transform((Collection)metadataContext.getRefs(), Ref::getLatestCommit)).traverse(false);
        if (context.containsKey("withMessages")) {
            builder.withMessages(Boolean.TRUE.equals(context.get("withMessages")));
        }
        return builder.build();
    }

    private Page<Commit> enrichCommits(Repository repository, Page<Commit> commits) {
        return this.commitEnricher.enrichPage(repository, commits, null);
    }
}

