/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch;

import com.atlassian.bitbucket.branch.model.BranchModel;
import com.atlassian.bitbucket.branch.model.BranchModelService;
import com.atlassian.bitbucket.branch.model.BranchType;
import com.atlassian.bitbucket.branch.model.BranchTypes;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMerge;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMergeService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeability;
import com.atlassian.bitbucket.pull.PullRequestMergeabilityPropertyProvider;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.SecurityService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Map;

public class MergeConflictPropertyProvider
implements PullRequestMergeabilityPropertyProvider {
    static final String PROP_PREFIX = "branch.";
    static final String PROP_CASCADING_MERGE_CONFLICT = "branch.cascading-merge-conflict";
    static final String PROP_SOURCE_BRANCH_STABILITY = "branch.from-ref-stability";
    private final CascadingMergeService cascadingMergeService;
    private final BranchModelService branchModelService;
    private final SecurityService securityService;

    public MergeConflictPropertyProvider(CascadingMergeService cascadingMergeService, BranchModelService branchModelService, SecurityService securityService) {
        this.cascadingMergeService = cascadingMergeService;
        this.branchModelService = branchModelService;
        this.securityService = securityService;
    }

    @Nonnull
    public Map<String, Object> provideProperties(@Nonnull PullRequest pullRequest, @Nonnull PullRequestMergeability mergeability) {
        if (!mergeability.isConflicted()) {
            return Collections.emptyMap();
        }
        if (this.isCascadingMergeConflict(pullRequest)) {
            return ImmutableMap.of((Object)PROP_CASCADING_MERGE_CONFLICT, (Object)true, (Object)PROP_SOURCE_BRANCH_STABILITY, (Object)"stable");
        }
        return this.provideSourceStabilityProperty(pullRequest);
    }

    private boolean isCascadingMergeConflict(PullRequest pullRequest) {
        if (pullRequest.isCrossRepository()) {
            return false;
        }
        CascadingMerge cascadingMerge = this.cascadingMergeService.getCascadingMerge(pullRequest.getFromRef().getRepository(), (Ref)pullRequest.getFromRef());
        Branch nextBranch = (Branch)Iterables.get(cascadingMerge.getPath(), (int)1, null);
        return nextBranch != null && nextBranch.getId().equals(pullRequest.getToRef().getId());
    }

    private Map<String, Object> provideSourceStabilityProperty(PullRequest pullRequest) {
        BranchModel model = this.getModelForRepository(pullRequest.getFromRef().getRepository());
        if (MergeConflictPropertyProvider.isUnstable(model, (MinimalRef)pullRequest.getFromRef())) {
            return ImmutableMap.of((Object)PROP_SOURCE_BRANCH_STABILITY, (Object)"unstable");
        }
        if (MergeConflictPropertyProvider.isStable(model, (MinimalRef)pullRequest.getFromRef())) {
            return ImmutableMap.of((Object)PROP_SOURCE_BRANCH_STABILITY, (Object)"stable");
        }
        return Collections.emptyMap();
    }

    private BranchModel getModelForRepository(Repository repository) {
        return (BranchModel)this.securityService.withPermission(Permission.REPO_READ, (Object)repository, "using branch model to determine source branch stability").call(() -> this.branchModelService.getModel(repository));
    }

    private static boolean isUnstable(BranchModel model, MinimalRef branch) {
        BranchType branchType = model.getClassifier().getType(branch);
        return BranchTypes.BUGFIX.matcher().test(branchType) || BranchTypes.HOTFIX.matcher().test(branchType) || BranchTypes.FEATURE.matcher().test(branchType);
    }

    private static boolean isStable(BranchModel model, MinimalRef branch) {
        BranchType branchType = model.getClassifier().getType(branch);
        return BranchTypes.RELEASE.matcher().test(branchType) || model.getDevelopment() != null && branch.getId().equals(model.getDevelopment().getId()) || model.getProduction() != null && branch.getId().equals(model.getProduction().getId());
    }
}

