/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.analytics;

import com.atlassian.bitbucket.event.pull.PullRequestOpenedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryPushEvent;
import com.atlassian.bitbucket.internal.branch.analytics.AnalyticsBranchClassifier;
import com.atlassian.bitbucket.internal.branch.analytics.AnalyticsBranchType;
import com.atlassian.bitbucket.internal.branch.analytics.AnalyticsBranchTypePullRequestOpenedEvent;
import com.atlassian.bitbucket.internal.branch.analytics.AnalyticsBranchTypeRepositoryPushEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import java.util.Collection;

public class AnalyticsBranchTypeListener {
    private final EventPublisher eventPublisher;
    private final AnalyticsBranchClassifier classifier;

    public AnalyticsBranchTypeListener(EventPublisher eventPublisher, AnalyticsBranchClassifier classifier) {
        this.eventPublisher = eventPublisher;
        this.classifier = classifier;
    }

    @EventListener
    public void onPullRequestOpened(PullRequestOpenedEvent event) {
        PullRequest pullRequest = event.getPullRequest();
        PullRequestRef fromRef = pullRequest.getFromRef();
        PullRequestRef toRef = pullRequest.getToRef();
        this.eventPublisher.publish((Object)new AnalyticsBranchTypePullRequestOpenedEvent(this, pullRequest, this.classifier.classifyRef(fromRef.getRepository(), (MinimalRef)fromRef), this.classifier.classifyRef(toRef.getRepository(), (MinimalRef)toRef)));
    }

    @EventListener
    public void onRepositoryPushEvent(RepositoryPushEvent event) {
        Repository repository = event.getRepository();
        Collection refChanges = event.getRefChanges();
        if (refChanges.isEmpty()) {
            return;
        }
        AnalyticsBranchType branchType = refChanges.size() > 1 ? AnalyticsBranchType.MULTIPLE : this.classifier.classifyRef(repository, ((RefChange)refChanges.iterator().next()).getRef());
        this.eventPublisher.publish((Object)new AnalyticsBranchTypeRepositoryPushEvent(this, repository, branchType));
    }
}

