/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.analytics;

import com.atlassian.bitbucket.branch.model.BranchModel;
import com.atlassian.bitbucket.branch.model.BranchModelService;
import com.atlassian.bitbucket.branch.model.BranchType;
import com.atlassian.bitbucket.branch.model.BranchTypes;
import com.atlassian.bitbucket.internal.branch.analytics.AnalyticsBranchClassifier;
import com.atlassian.bitbucket.internal.branch.analytics.AnalyticsBranchType;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.EmptyRepositoryException;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;

public class DefaultAnalyticsBranchClassifier
implements AnalyticsBranchClassifier {
    private final BranchModelService branchModelService;
    private final RefService refService;

    public DefaultAnalyticsBranchClassifier(@Nonnull BranchModelService branchModelService, @Nonnull RefService refService) {
        this.branchModelService = branchModelService;
        this.refService = refService;
    }

    @Override
    @Nonnull
    public AnalyticsBranchType classifyRef(@Nonnull Repository repository, @Nonnull MinimalRef ref) {
        try {
            BranchModel branchModel = this.branchModelService.getModel(repository);
            BranchType branchType = branchModel.getClassifier().getType(ref);
            if (BranchTypes.BUGFIX.matcher().test(branchType)) {
                return AnalyticsBranchType.BUGFIX;
            }
            if (BranchTypes.FEATURE.matcher().test(branchType)) {
                return AnalyticsBranchType.FEATURE;
            }
            if (BranchTypes.HOTFIX.matcher().test(branchType)) {
                return AnalyticsBranchType.HOTFIX;
            }
            if (BranchTypes.RELEASE.matcher().test(branchType)) {
                return AnalyticsBranchType.RELEASE;
            }
            if (branchModel.getDevelopment().getId().equals(ref.getId())) {
                return AnalyticsBranchType.DEVELOPMENT;
            }
            if (branchModel.getProduction() != null && branchModel.getProduction().getId().equals(ref.getId())) {
                return AnalyticsBranchType.PRODUCTION;
            }
            Branch defaultBranch = this.refService.getDefaultBranch(repository);
            if (ref.getId().equals(defaultBranch.getId())) {
                return AnalyticsBranchType.DEFAULT;
            }
        }
        catch (EmptyRepositoryException | NoDefaultBranchException e) {
            return AnalyticsBranchType.OTHER;
        }
        return AnalyticsBranchType.OTHER;
    }
}

