/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.atst;

import com.atlassian.bitbucket.branch.model.BranchModel;
import com.atlassian.bitbucket.branch.model.BranchModelService;
import com.atlassian.bitbucket.branch.model.configuration.BranchConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfigurationService;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.EmptyRepositoryException;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import jakarta.annotation.Nonnull;

public class BranchModelSupportDataHelper {
    private static final String PLUGINS_BRANCH_MODEL = "bitbucket.atst.branch.model";
    private static final String PLUGINS_BRANCH_MODEL_BRANCH_TYPE = "bitbucket.atst.branch.model.branch.type";
    private static final String PLUGINS_BRANCH_MODEL_DEV_REFID = "bitbucket.atst.branch.model.development.refId";
    private static final String PLUGINS_BRANCH_MODEL_DEV_USE_DEFAULT = "bitbucket.atst.branch.model.development.useDefault";
    private static final String PLUGINS_BRANCH_MODEL_PROD_REFID = "bitbucket.atst.branch.model.production.refId";
    private static final String PLUGINS_BRANCH_MODEL_PROD_USE_DEFAULT = "bitbucket.atst.branch.model.production.useDefault";
    private static final String PLUGINS_BRANCH_MODEL_SCOPE = "bitbucket.atst.branch.model.scope";
    private final BranchModelConfigurationService branchModelConfigurationService;
    private final BranchModelService branchModelService;

    public BranchModelSupportDataHelper(BranchModelService branchModelService, BranchModelConfigurationService branchModelConfigurationService) {
        this.branchModelConfigurationService = branchModelConfigurationService;
        this.branchModelService = branchModelService;
    }

    public void addBranchModel(@Nonnull SupportDataBuilder builder, @Nonnull Scope scope) {
        final SupportDataBuilder branchModelBuilder = builder.addCategory(PLUGINS_BRANCH_MODEL);
        BranchModelConfiguration configuration = this.branchModelConfigurationService.getConfiguration(scope);
        if (scope.getType() == ScopeType.REPOSITORY && configuration.getScope().getType() == ScopeType.PROJECT) {
            scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

                public Void visit(@Nonnull RepositoryScope scope) {
                    try {
                        BranchModel model = BranchModelSupportDataHelper.this.branchModelService.getModel(scope.getRepository());
                        BranchModelSupportDataHelper.this.addInheritedModel(branchModelBuilder, model);
                    }
                    catch (EmptyRepositoryException emptyRepositoryException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        } else {
            this.addBranchModelDetails(branchModelBuilder, configuration);
        }
    }

    private void addBranchModelDetails(@Nonnull SupportDataBuilder branchModelBuilder, @Nonnull BranchModelConfiguration configuration) {
        branchModelBuilder.addValue(PLUGINS_BRANCH_MODEL_SCOPE, configuration.getScope().getType().name());
        branchModelBuilder.addValue(PLUGINS_BRANCH_MODEL_DEV_REFID, configuration.getDevelopment().getRefId());
        branchModelBuilder.addValue(PLUGINS_BRANCH_MODEL_DEV_USE_DEFAULT, String.valueOf(configuration.getDevelopment().isUseDefault()));
        BranchConfiguration prod = configuration.getProduction();
        if (prod != null) {
            branchModelBuilder.addValue(PLUGINS_BRANCH_MODEL_PROD_REFID, prod.getRefId());
            branchModelBuilder.addValue(PLUGINS_BRANCH_MODEL_PROD_USE_DEFAULT, String.valueOf(prod.isUseDefault()));
        }
        SupportDataBuilder typeBuilder = branchModelBuilder.addCategory(PLUGINS_BRANCH_MODEL_BRANCH_TYPE);
        configuration.getTypes().forEach(branchType -> typeBuilder.addValue("bitbucket.atst.branch.model.branch.type." + branchType.getId(), branchType.getPrefix()));
    }

    private void addInheritedModel(@Nonnull SupportDataBuilder builder, @Nonnull BranchModel model) {
        builder.addValue("inherited", "true");
        builder.addValue(PLUGINS_BRANCH_MODEL_DEV_REFID, model.getDevelopment().getId());
        Branch prod = model.getProduction();
        if (prod != null) {
            builder.addValue(PLUGINS_BRANCH_MODEL_PROD_REFID, prod.getId());
        }
    }
}

