/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.audit;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.bitbucket.audit.AuditEventConverter;
import com.atlassian.bitbucket.branch.model.BranchType;
import com.atlassian.bitbucket.branch.model.BranchTypes;
import com.atlassian.bitbucket.branch.model.configuration.BranchConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchTypeConfiguration;
import com.atlassian.bitbucket.internal.branch.model.event.BranchModelConfigurationCreatedEvent;
import com.atlassian.bitbucket.internal.branch.model.event.BranchModelConfigurationEvent;
import com.atlassian.bitbucket.internal.branch.model.event.BranchModelConfigurationUpdatedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.function.Function;

public class BranchModelConfigurationEventConverter
implements AuditEventConverter<BranchModelConfigurationEvent> {
    @VisibleForTesting
    static final String ACTION_REPOSITORY_BRANCH_MODEL_CREATED = "bitbucket.branch.audit.action.repositorybranchmodelconfigurationcreated";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_BRANCH_MODEL_UPDATED = "bitbucket.branch.audit.action.repositorybranchmodelconfigurationupdated";
    @VisibleForTesting
    static final String ATTR_BUGFIX_PREFIX = "bitbucket.branch.audit.attribute.branchmodel.bugfixprefix";
    @VisibleForTesting
    static final String ATTR_DEVELOPMENT_BRANCH = "bitbucket.branch.audit.attribute.branchmodel.developmentbranch";
    @VisibleForTesting
    static final String ATTR_FEATURE_PREFIX = "bitbucket.branch.audit.attribute.branchmodel.featureprefix";
    @VisibleForTesting
    static final String ATTR_HOTFIX_PREFIX = "bitbucket.branch.audit.attribute.branchmodel.hotfixprefix";
    @VisibleForTesting
    static final String ATTR_PRODUCTION_BRANCH = "bitbucket.branch.audit.attribute.branchmodel.productionbranch";
    @VisibleForTesting
    static final String ATTR_RELEASE_PREFIX = "bitbucket.branch.audit.attribute.branchmodel.releaseprefix";
    @VisibleForTesting
    static final String DEFAULT_BRANCH = "(default branch)";
    private static final String NO_BRANCH = "(none)";

    @Nonnull
    public AuditEvent convert(final @Nonnull BranchModelConfigurationEvent event, final @Nonnull AuditEvent.Builder builder) {
        event.getScope().accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope projectScope) {
                builder.affectedObject(AuditUtils.auditResourceForProject((Project)projectScope.getProject()));
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                builder.actionI18nKey(event instanceof BranchModelConfigurationUpdatedEvent ? BranchModelConfigurationEventConverter.ACTION_REPOSITORY_BRANCH_MODEL_UPDATED : BranchModelConfigurationEventConverter.ACTION_REPOSITORY_BRANCH_MODEL_CREATED).categoryI18nKey("bitbucket.service.audit.category.repositories").affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)repositoryScope.getRepository()));
                return null;
            }
        });
        if (event instanceof BranchModelConfigurationUpdatedEvent) {
            return BranchModelConfigurationEventConverter.addChangedValues((BranchModelConfigurationUpdatedEvent)event, builder).build();
        }
        return BranchModelConfigurationEventConverter.addExtraAttributes((BranchModelConfigurationCreatedEvent)event, builder).build();
    }

    private static AuditEvent.Builder addChangedValues(BranchModelConfigurationUpdatedEvent event, AuditEvent.Builder builder) {
        BranchModelConfiguration newConfig = event.getNewConfiguration();
        BranchModelConfiguration oldConfig = event.getOldConfiguration().get();
        builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_DEVELOPMENT_BRANCH).from(BranchModelConfigurationEventConverter.branchConfigurationToString(oldConfig.getDevelopment())).to(BranchModelConfigurationEventConverter.branchConfigurationToString(newConfig.getDevelopment())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_PRODUCTION_BRANCH).from(BranchModelConfigurationEventConverter.branchConfigurationToString(oldConfig.getProduction())).to(BranchModelConfigurationEventConverter.branchConfigurationToString(newConfig.getProduction())).build());
        Map branchTypeConfigurationMap = (Map)oldConfig.getTypes().stream().collect(MoreCollectors.toImmutableMap(BranchType::getId, Function.identity()));
        newConfig.getTypes().forEach(typeConfig -> builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)BranchModelConfigurationEventConverter.branchTypeConfigurationToI18nKey(typeConfig)).from(BranchModelConfigurationEventConverter.branchTypeConfigurationToString((BranchTypeConfiguration)branchTypeConfigurationMap.get(typeConfig.getId()))).to(BranchModelConfigurationEventConverter.branchTypeConfigurationToString(typeConfig)).build()));
        return builder;
    }

    private static AuditEvent.Builder addExtraAttributes(BranchModelConfigurationCreatedEvent event, AuditEvent.Builder builder) {
        BranchModelConfiguration newConfig = event.getNewConfiguration();
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_DEVELOPMENT_BRANCH, (String)BranchModelConfigurationEventConverter.branchConfigurationToString(newConfig.getDevelopment())).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_PRODUCTION_BRANCH, (String)BranchModelConfigurationEventConverter.branchConfigurationToString(newConfig.getProduction())).build());
        newConfig.getTypes().forEach(typeConfig -> {
            if (typeConfig.isEnabled()) {
                builder.extraAttribute(AuditAttribute.fromI18nKeys((String)BranchModelConfigurationEventConverter.branchTypeConfigurationToI18nKey(typeConfig), (String)BranchModelConfigurationEventConverter.branchTypeConfigurationToString(typeConfig)).build());
            }
        });
        return builder;
    }

    private static String branchConfigurationToString(BranchConfiguration config) {
        if (config == null) {
            return NO_BRANCH;
        }
        if (config.isUseDefault()) {
            return DEFAULT_BRANCH;
        }
        return config.getRefId();
    }

    private static String branchTypeConfigurationToI18nKey(BranchTypeConfiguration config) {
        if (BranchTypes.BUGFIX.matcher().test(config)) {
            return ATTR_BUGFIX_PREFIX;
        }
        if (BranchTypes.FEATURE.matcher().test(config)) {
            return ATTR_FEATURE_PREFIX;
        }
        if (BranchTypes.HOTFIX.matcher().test(config)) {
            return ATTR_HOTFIX_PREFIX;
        }
        if (BranchTypes.RELEASE.matcher().test(config)) {
            return ATTR_RELEASE_PREFIX;
        }
        return config.getDisplayName();
    }

    private static String branchTypeConfigurationToString(BranchTypeConfiguration config) {
        return config.isEnabled() ? config.getPrefix() : null;
    }
}

