/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.branch.cascadingmerge.CascadingMergeEvent;
import com.atlassian.bitbucket.branch.cascadingmerge.CascadingMergeStoppedEvent;
import com.atlassian.bitbucket.branch.cascadingmerge.CascadingMergeSucceededEvent;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfiguration;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.event.CascadingMergeConfigUpdatedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CascadingMergeEventListener {
    @VisibleForTesting
    static final String ACTION_CASCADING_MERGE_STOPPED = "bitbucket.cascadingmerge.audit.action.cascadingmergestopped";
    @VisibleForTesting
    static final String ACTION_CASCADING_MERGE_SUCCEEDED = "bitbucket.cascadingmerge.audit.action.cascadingmergesucceeded";
    @VisibleForTesting
    static final String ACTION_PROJECT_CASCADING_MERGE_CONFIG_UPDATED = "bitbucket.cascadingmerge.audit.action.projectcascadingmergeconfigupdated";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_CASCADING_MERGE_CONFIG_UPDATED = "bitbucket.cascadingmerge.audit.action.repositorycascadingmergeconfigupdated";
    @VisibleForTesting
    static final String ATTR_MERGE_PATH = "bitbucket.cascadingmerge.audit.attribute.cascadingmerge.mergepath";
    @VisibleForTesting
    static final String ATTR_REASON = "bitbucket.cascadingmerge.audit.attribute.cascadingmerge.reason";
    @VisibleForTesting
    static final String ATTR_REF_CHANGES = "bitbucket.cascadingmerge.audit.attribute.cascadingmerge.refchanges";
    @VisibleForTesting
    static final String KEY_CASCADING_MERGE_ENABLED = "bitbucket.cascadingmerge.audit.key.cascadingmergeconfigupdated.cascadingmergeenabled";
    @VisibleForTesting
    static final String KEY_MERGE_CHECK_ENABLED = "bitbucket.cascadingmerge.audit.key.cascadingmergeconfigupdated.mergecheckenabled";
    private final AuditService auditService;

    public CascadingMergeEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onCascadingMergeConfigUpdatedEvent(CascadingMergeConfigUpdatedEvent event) {
        final AuditEvent.Builder builder = AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)ACTION_PROJECT_CASCADING_MERGE_CONFIG_UPDATED).build());
        event.getScope().accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope projectScope) {
                builder.affectedObject(AuditUtils.auditResourceForProject((Project)projectScope.getProject()));
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                builder.actionI18nKey(CascadingMergeEventListener.ACTION_REPOSITORY_CASCADING_MERGE_CONFIG_UPDATED).categoryI18nKey("bitbucket.service.audit.category.repositories").affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)repositoryScope.getRepository()));
                return null;
            }
        });
        CascadingMergeConfiguration newConfig = event.getNewConfig();
        CascadingMergeConfiguration oldConfig = event.getOldConfig();
        builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_CASCADING_MERGE_ENABLED).from(String.valueOf(oldConfig.isEnabled())).to(String.valueOf(newConfig.isEnabled())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_MERGE_CHECK_ENABLED).from(String.valueOf(oldConfig.isMergeCheckEnabled())).to(String.valueOf(newConfig.isMergeCheckEnabled())).build());
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onCascadingMergeStoppedEvent(CascadingMergeStoppedEvent event) {
        AuditEvent.Builder builder = CascadingMergeEventListener.toAuditEventBuilder(event, ACTION_CASCADING_MERGE_STOPPED).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_REASON, (String)event.getReason().name()).build());
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onCascadingMergeSucceededEvent(CascadingMergeSucceededEvent event) {
        this.auditService.audit(CascadingMergeEventListener.toAuditEventBuilder(event, ACTION_CASCADING_MERGE_SUCCEEDED).build());
    }

    private static AuditEvent.Builder toAuditEventBuilder(CascadingMergeEvent event, String action) {
        List mergePaths = MoreStreams.streamIterable(event.getMergePath()).map(MinimalRef::getDisplayId).collect(Collectors.toList());
        List refChanges = event.getRefChanges().stream().map(change -> ImmutableMap.of((Object)"ref", (Object)change.getRef().getId(), (Object)"from", (Object)change.getFromHash().substring(0, 10), (Object)"to", (Object)change.getToHash().substring(0, 10))).collect(Collectors.toList());
        return AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.pullrequests", (String)action).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_MERGE_PATH, (String)StringUtils.join(mergePaths, (String)" -> ")).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_REF_CHANGES, (String)refChanges.toString()).build()).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)event.getRepository()));
    }
}

