/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.MergeInstruction;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.BranchPermissionReason;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeFailedReason;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeResult;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeStopped;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.OpenPullRequestReason;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.StopReason;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.mail.SoyMailBuilder;
import com.atlassian.bitbucket.mail.SoyMailMessageRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Pair;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CascadingMergeMailer {
    private static final Logger log = LoggerFactory.getLogger(CascadingMergeMailer.class);
    private static final String NOTIFICATION_MODULE = "com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles";
    private static final String CSS_KEY = "com.atlassian.bitbucket.server.bitbucket-branch:cascadingmerge-mail-styles";
    private static final String TEMPLATE_KEY = "com.atlassian.bitbucket.server.bitbucket-branch:cascadingmerge-mail-templates";
    private final AuthenticationContext authContext;
    private final MailService mailService;
    private final SoyMailBuilder soyMailBuilder;

    public CascadingMergeMailer(AuthenticationContext authContext, MailService mailService, SoyMailBuilder soyMailBuilder) {
        this.authContext = authContext;
        this.mailService = mailService;
        this.soyMailBuilder = soyMailBuilder;
    }

    public void mailError(List<Pair<MergeInstruction, MergeResult>> results, List<Branch> mergePath, PullRequest pullRequest, Either<Exception, PullRequest> newPullRequest) {
        Pair<MergeInstruction, MergeResult> lastResult = results.get(results.size() - 1);
        Repository repository = ((MergeInstruction)lastResult.left()).getRepository();
        Branch source = ((MergeInstruction)lastResult.left()).getSource();
        Branch destination = ((MergeInstruction)lastResult.left()).getDestination();
        if (!this.mailService.isHostConfigured()) {
            this.logNoMailConfiguration(repository, source, destination);
            return;
        }
        String errorType = this.getErrorType((MergeResult)lastResult.right());
        ApplicationUser currentUser = this.authContext.getCurrentUser();
        List<Map<String, String>> resultData = this.getResultData(results, mergePath);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("date", new Date());
        context.put("errorType", errorType);
        context.put("fromRef", source);
        context.put("moduleKey", CSS_KEY);
        context.put("notificationModuleKey", NOTIFICATION_MODULE);
        context.put("pullRequest", newPullRequest.right().getOrElse((Object)null));
        context.put("toRef", destination);
        context.put("unknownError", newPullRequest.left().getOrElse((Object)null));
        context.put("user", currentUser);
        context.put("results", resultData);
        SoyMailMessageRequest messageRequest = new SoyMailMessageRequest.Builder().cssModuleKey(CSS_KEY).context(context).recipients(Collections.singleton(currentUser)).soyTemplateModuleKey(TEMPLATE_KEY).soyTemplateName("bitbucketPluginBranch.internal.feature.branch.cascadingmerge.mail.cascadingmergeMail.error").subjectKey(new I18nKey("bitbucket.notification.email.pullrequest.title", new Object[]{repository.getProject().getKey(), repository.getName(), String.valueOf(pullRequest.getId()), pullRequest.getTitle()})).build();
        this.soyMailBuilder.build(messageRequest).forEach(arg_0 -> ((MailService)this.mailService).submit(arg_0));
    }

    private String getErrorType(MergeResult result) {
        if (result instanceof MergeStopped) {
            StopReason stopReason = ((MergeStopped)result).getReason();
            if (stopReason instanceof BranchPermissionReason) {
                return "permission";
            }
            if (stopReason instanceof MergeFailedReason) {
                return "conflict";
            }
            if (stopReason instanceof OpenPullRequestReason) {
                return "openpr";
            }
        }
        return "unknown";
    }

    private List<Map<String, String>> getResultData(List<Pair<MergeInstruction, MergeResult>> results, List<Branch> mergePath) {
        Map<Branch, String> branchStatus = results.stream().collect(Collectors.toMap(r -> ((MergeInstruction)r.left()).getDestination(), r -> r.right() instanceof MergeStopped ? "failed" : "merged"));
        return mergePath.stream().skip(1L).map(branch -> ImmutableMap.of((Object)"branch", (Object)branch.getDisplayId(), (Object)"status", (Object)branchStatus.getOrDefault(branch, "notattempted"))).collect(Collectors.toList());
    }

    private void logNoMailConfiguration(Repository repository, Branch source, Branch destination) {
        log.warn("No mail configuration: discarding notification for cascading merge failure when merging {} to {} in {}/{}.", new Object[]{source.getDisplayId(), destination.getDisplayId(), repository.getProject().getKey(), repository.getSlug()});
    }
}

