/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge;

import com.atlassian.bitbucket.internal.branch.cascadingmerge.BranchProcessor;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.MergeInstruction;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeContinue;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeResult;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeStopped;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class CascadingMergeProcessor {
    private final List<BranchProcessor> processors;

    public CascadingMergeProcessor(List<BranchProcessor> processors) {
        Preconditions.checkArgument((processors != null && !processors.isEmpty() ? 1 : 0) != 0, (Object)"must have at least one processor");
        processors = new ArrayList<BranchProcessor>(processors);
        AnnotationAwareOrderComparator.sort(processors);
        this.processors = ImmutableList.copyOf(processors);
    }

    public List<Pair<MergeInstruction, MergeResult>> cascadingMerge(Repository repository, List<Branch> path) {
        if (path.size() < 2) {
            return Collections.emptyList();
        }
        ArrayList<Pair<MergeInstruction, MergeResult>> results = new ArrayList<Pair<MergeInstruction, MergeResult>>(path.size());
        for (int i = 0; i < path.size() - 1; ++i) {
            Branch source = path.get(i);
            Branch destination = path.get(i + 1);
            MergeInstruction mergeInstruction = new MergeInstruction(repository, source, destination, false);
            MergeResult result = this.process(mergeInstruction);
            results.add((Pair<MergeInstruction, MergeResult>)Pair.pair((Object)mergeInstruction, (Object)result));
            if (result instanceof MergeStopped) break;
        }
        return results;
    }

    private MergeResult process(MergeInstruction mergeInstruction) {
        MergeResult result = null;
        for (BranchProcessor processor : this.processors) {
            result = processor.process(mergeInstruction);
            if (result instanceof MergeContinue) continue;
            return result;
        }
        return result;
    }
}

