/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge;

import com.atlassian.bitbucket.branch.cascadingmerge.CascadingMergeEvent;
import com.atlassian.bitbucket.branch.cascadingmerge.CascadingMergeStoppedEvent;
import com.atlassian.bitbucket.branch.cascadingmerge.CascadingMergeSucceededEvent;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.concurrent.RepositoryLock;
import com.atlassian.bitbucket.event.pull.PullRequestMergedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMerge;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMergeMailer;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMergeProcessor;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMergeService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.MergeInstruction;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.BranchPermissionReason;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeResult;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeStopped;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeSuccess;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.OpenPullRequestReason;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.StopReason;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestCreateRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Pair;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CascadingMergePullRequestListener {
    static final String KEY_CONFLICTED_DESC_CONF = "bitbucket.cascadingmerge.conflicted.pull-request.description.conflict";
    static final String KEY_CONFLICTED_DESC_PERM = "bitbucket.cascadingmerge.conflicted.pull-request.description.permission";
    static final String KEY_CONFLICTED_TITLE = "bitbucket.cascadingmerge.conflicted.pull-request.title";
    static final String LOCK_NAME = "cascading-merge";
    private static final Logger log = LoggerFactory.getLogger(CascadingMergePullRequestListener.class);
    private final ApplicationPropertiesService applicationPropertiesService;
    private final CascadingMergeProcessor cascadingMergeProcessor;
    private final CascadingMergeService cascadingMergeService;
    private final EventPublisher eventPublisher;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final CascadingMergeMailer mailer;
    private final PullRequestService pullRequestService;
    private final SecurityService securityService;
    private final RepositoryLock repositoryLock;

    public CascadingMergePullRequestListener(ApplicationPropertiesService applicationPropertiesService, CascadingMergeProcessor cascadingMergeProcessor, CascadingMergeService cascadingMergeService, EventPublisher eventPublisher, ExecutorService executorService, I18nService i18nService, LockService lockService, CascadingMergeMailer mailer, PullRequestService pullRequestService, SecurityService securityService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.cascadingMergeProcessor = cascadingMergeProcessor;
        this.cascadingMergeService = cascadingMergeService;
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.mailer = mailer;
        this.pullRequestService = pullRequestService;
        this.securityService = securityService;
        this.repositoryLock = lockService.getRepositoryLock(LOCK_NAME);
    }

    @EventListener
    public void onPullRequestMerged(PullRequestMergedEvent event) {
        Repository repository = event.getRepository();
        PullRequestRef ref = event.getPullRequest().getToRef();
        ApplicationUser user = event.getUser();
        if (user == null) {
            log.debug("No cascading merge for ref {} because user of event was null", (Object)ref);
            return;
        }
        CascadingMerge cascadingMergeInfo = this.cascadingMergeService.getCascadingMerge(repository, (Ref)ref);
        if (!cascadingMergeInfo.getStatus().isAvailable()) {
            log.debug("No cascading merge for ref {}, reason: {}", (Object)ref, (Object)cascadingMergeInfo.getStatus());
            return;
        }
        ImmutableList branches = ImmutableList.copyOf(cascadingMergeInfo.getPath());
        if (log.isDebugEnabled()) {
            String mergePath = branches.stream().map(MinimalRef::getId).collect(Collectors.joining(","));
            log.debug("Cascading merging branches for {}/{}. Merge path: {}", new Object[]{repository.getProject().getKey(), repository.getSlug(), mergePath});
        }
        this.securityService.impersonating(user, "Cascading merging branches").call(() -> this.lambda$onPullRequestMerged$2(repository, (List)branches, event));
    }

    @VisibleForTesting
    void processResults(List<Pair<MergeInstruction, MergeResult>> results, List<Branch> mergePath, PullRequest pullRequest) {
        if (results.isEmpty()) {
            return;
        }
        Pair<MergeInstruction, MergeResult> lastResult = results.get(results.size() - 1);
        if (lastResult.right() instanceof MergeStopped) {
            MergeStopped mergeStopped = (MergeStopped)lastResult.right();
            MergeInstruction instruction = (MergeInstruction)lastResult.left();
            this.sendEvent(results, mergePath, mergeStopped.getReason());
            Either<Exception, PullRequest> newPullRequest = this.getOrCreatePullRequest(mergeStopped.getReason(), instruction);
            this.mailer.mailError(results, mergePath, pullRequest, newPullRequest);
        } else {
            this.sendEvent(results, mergePath, null);
        }
    }

    private PullRequest createPullRequest(MergeInstruction instruction, String titleKey, String descriptionKey) {
        Repository repository = instruction.getRepository();
        Locale defaultLocale = this.applicationPropertiesService.getLocale();
        return this.pullRequestService.create(((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)new PullRequestCreateRequest.Builder().title(this.i18nService.getMessage(defaultLocale, titleKey, new Object[0]))).description(this.i18nService.getMessage(defaultLocale, descriptionKey, new Object[0]))).fromRefId(instruction.getSource().getId())).repository(repository)).toBranchId(instruction.getDestination().getId())).build());
    }

    private CascadingMergeEvent createStoppedEvent(Repository repository, List<RefChange> refChanges, List<Branch> mergePath, StopReason reason) {
        return new CascadingMergeStoppedEvent(this, repository, refChanges, mergePath, reason.getApiReason());
    }

    private CascadingMergeEvent createSucceededEvent(Repository repository, List<RefChange> refChanges, List<Branch> mergePath) {
        return new CascadingMergeSucceededEvent(this, repository, refChanges, mergePath);
    }

    private Either<Exception, PullRequest> getOrCreatePullRequest(StopReason stopReason, MergeInstruction instruction) {
        if (stopReason instanceof OpenPullRequestReason) {
            OpenPullRequestReason reason = (OpenPullRequestReason)stopReason;
            return Either.right((Object)reason.getPullRequest());
        }
        String descKey = KEY_CONFLICTED_DESC_CONF;
        if (stopReason instanceof BranchPermissionReason) {
            descKey = KEY_CONFLICTED_DESC_PERM;
        }
        try {
            return Either.right((Object)this.createPullRequest(instruction, KEY_CONFLICTED_TITLE, descKey));
        }
        catch (Exception e) {
            return Either.left((Object)e);
        }
    }

    private void sendEvent(List<Pair<MergeInstruction, MergeResult>> results, List<Branch> mergePath, StopReason stopReason) {
        if (results.isEmpty()) {
            return;
        }
        Repository repository = ((MergeInstruction)results.get(0).left()).getRepository();
        List<RefChange> refChanges = results.stream().flatMap(result -> {
            Object patt0$temp = result.right();
            if (patt0$temp instanceof MergeSuccess) {
                MergeSuccess mergeSuccess = (MergeSuccess)patt0$temp;
                return Stream.of(mergeSuccess.getRefChange());
            }
            return Stream.empty();
        }).collect(Collectors.toList());
        CascadingMergeEvent event = stopReason == null ? this.createSucceededEvent(repository, refChanges, mergePath) : this.createStoppedEvent(repository, refChanges, mergePath, stopReason);
        this.eventPublisher.publish((Object)event);
    }

    private /* synthetic */ Object lambda$onPullRequestMerged$2(Repository repository, List branches, PullRequestMergedEvent event) throws RuntimeException {
        this.executorService.execute(() -> this.repositoryLock.withLock(repository, () -> {
            this.processResults(this.cascadingMergeProcessor.cascadingMerge(repository, branches), branches, event.getPullRequest());
            return null;
        }));
        return null;
    }
}

