/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge;

import com.atlassian.bitbucket.branch.model.BranchModel;
import com.atlassian.bitbucket.branch.model.BranchModelService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.BranchProcessor;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMerge;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMergeService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMergeStatus;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.MergeInstruction;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.SimpleCascadingMerge;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfigurationService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeResult;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeStopped;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.StopReason;
import com.atlassian.bitbucket.internal.branch.model.BranchModelNode;
import com.atlassian.bitbucket.internal.branch.model.InternalBranchModel;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleBranch;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;

public class DefaultCascadingMergeService
implements CascadingMergeService {
    private final BranchModelService branchModelService;
    private final CascadingMergeConfigurationService cascadingMergeConfigService;
    private final List<BranchProcessor> downstreamProcessors;

    public DefaultCascadingMergeService(BranchModelService branchModelService, CascadingMergeConfigurationService cascadingMergeConfigService, List<BranchProcessor> downstreamProcessors) {
        this.branchModelService = branchModelService;
        this.cascadingMergeConfigService = cascadingMergeConfigService;
        this.downstreamProcessors = downstreamProcessors;
    }

    @Override
    @Nonnull
    public CascadingMerge getCascadingMerge(@Nonnull Repository repository, @Nonnull Ref ref) {
        Branch branch = DefaultCascadingMergeService.convertRefToBranch(ref);
        BranchModel model = this.branchModelService.getModel(repository);
        if (!this.cascadingMergeConfigService.getConfiguration((Scope)Scopes.repository((Repository)repository)).isEnabled()) {
            return SimpleCascadingMerge.skip(CascadingMergeStatus.CASCADING_MERGE_DISABLED, branch);
        }
        BranchModelNode mergePath = DefaultCascadingMergeService.asInternalBranchModel(model).getMergePath(branch);
        List<Branch> downstream = DefaultCascadingMergeService.getAllDownstreamBranches(mergePath);
        if (downstream.size() <= 1) {
            return SimpleCascadingMerge.skip(CascadingMergeStatus.NO_PATH, branch);
        }
        int maxBranches = this.cascadingMergeConfigService.getLimit() + 1;
        if (downstream.size() > maxBranches) {
            return SimpleCascadingMerge.skip(CascadingMergeStatus.PATH_TOO_LONG, branch);
        }
        SimpleCascadingMerge.Builder cascadingMergeBuilder = new SimpleCascadingMerge.Builder(CascadingMergeStatus.PROCEED, downstream);
        this.calculateBlockages(repository, downstream, cascadingMergeBuilder);
        return cascadingMergeBuilder.build();
    }

    private static void addAllDownstreamBranches(BranchModelNode node, List<Branch> branches) {
        branches.add(node.getBranch());
        for (BranchModelNode downstream : node.getDownstream()) {
            DefaultCascadingMergeService.addAllDownstreamBranches(downstream, branches);
        }
    }

    private static InternalBranchModel asInternalBranchModel(BranchModel branchModel) {
        if (branchModel instanceof InternalBranchModel) {
            return (InternalBranchModel)branchModel;
        }
        throw new ClassCastException("Unexpected BranchModel implementation that is not an InternalBranchModel: " + branchModel.getClass().getName());
    }

    private static Branch convertRefToBranch(Ref ref) {
        if (ref instanceof Branch) {
            return (Branch)ref;
        }
        return ((SimpleBranch.Builder)((SimpleBranch.Builder)((SimpleBranch.Builder)new SimpleBranch.Builder().id(ref.getId())).displayId(ref.getDisplayId())).latestCommit(ref.getLatestCommit())).build();
    }

    private static List<Branch> getAllDownstreamBranches(BranchModelNode node) {
        ArrayList<Branch> branches = new ArrayList<Branch>();
        DefaultCascadingMergeService.addAllDownstreamBranches(node, branches);
        return branches;
    }

    private void calculateBlockages(@Nonnull Repository repository, List<Branch> downstream, SimpleCascadingMerge.Builder cascadingMergeBuilder) {
        for (int i = 0; i < downstream.size() - 1; ++i) {
            Branch source = downstream.get(i);
            Branch destination = downstream.get(i + 1);
            MergeInstruction mergeInstruction = new MergeInstruction(repository, source, destination, true);
            for (BranchProcessor processor : this.downstreamProcessors) {
                MergeResult result = processor.process(mergeInstruction);
                if (!(result instanceof MergeStopped)) continue;
                StopReason reason = ((MergeStopped)result).getReason();
                cascadingMergeBuilder.truncated(reason);
                return;
            }
        }
    }
}

