/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge;

import com.atlassian.bitbucket.internal.branch.cascadingmerge.BranchProcessor;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMergeProcessor;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.MergeInstruction;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.BranchPermissionReason;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeContinue;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeResult;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeStopped;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ref.restriction.RefAccessRequest;
import com.atlassian.bitbucket.repository.ref.restriction.RefAccessType;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=2)
public class HasPermission
implements BranchProcessor {
    private static final Logger log = LoggerFactory.getLogger(CascadingMergeProcessor.class);
    private final RefRestrictionService refRestrictionService;

    public HasPermission(RefRestrictionService refRestrictionService) {
        this.refRestrictionService = refRestrictionService;
    }

    @Override
    public MergeResult process(MergeInstruction mergeInstruction) {
        Branch destination;
        Repository repository = mergeInstruction.getRepository();
        RefAccessRequest accessRequest = new RefAccessRequest.Builder(repository, RefAccessType.UPDATE).ref((MinimalRef)(destination = mergeInstruction.getDestination())).build();
        if (this.refRestrictionService.hasPermission(accessRequest)) {
            return new MergeContinue();
        }
        if (!mergeInstruction.isDryRun()) {
            log.info("{}: Auto-merging {} to {} has been blocked by branch permissions", new Object[]{repository, mergeInstruction.getSource().getDisplayId(), destination.getDisplayId()});
        }
        return new MergeStopped(new BranchPermissionReason());
    }
}

