/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.BranchProcessor;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMergeProcessor;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.MergeInstruction;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfigurationService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeContinue;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeFailedReason;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeResult;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeStopped;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeSuccess;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.MergeCommandParameters;
import com.atlassian.bitbucket.scm.MergeException;
import com.atlassian.bitbucket.scm.ResolveRefCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.git.command.push.GitNonFastForwardUpdateRejectedException;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Operation;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=3)
public class MergeAction
implements BranchProcessor {
    private static final Logger log = LoggerFactory.getLogger(CascadingMergeProcessor.class);
    private final AuthenticationContext authenticationContext;
    private final CascadingMergeConfigurationService config;
    private final ScmService scmService;

    public MergeAction(AuthenticationContext authenticationContext, CascadingMergeConfigurationService config, ScmService scmService) {
        this.authenticationContext = authenticationContext;
        this.config = config;
        this.scmService = scmService;
    }

    @Override
    public MergeResult process(MergeInstruction mergeInstruction) {
        return new RetryingMergeOperation(mergeInstruction).perform();
    }

    private class RetryingMergeOperation
    implements Operation<MergeResult, RuntimeException> {
        private static final int MAX_MERGE_ATTEMPTS = 3;
        private final ApplicationUser currentUser;
        private final boolean isDryRun;
        private final Repository repository;
        private final Ref source;
        private Ref destination;

        public RetryingMergeOperation(MergeInstruction mergeInstruction) {
            this.repository = mergeInstruction.getRepository();
            this.source = mergeInstruction.getSource();
            this.destination = mergeInstruction.getDestination();
            this.isDryRun = mergeInstruction.isDryRun();
            this.currentUser = Objects.requireNonNull(MergeAction.this.authenticationContext.getCurrentUser(), "Cascading merges cannot be performed anonymously");
        }

        public MergeResult perform() {
            if (this.isDryRun) {
                log.debug("{}: Merge instruction is a dry run so not performing any cascading merge action from {} to {}.", new Object[]{this.repository, this.source.getDisplayId(), this.destination.getDisplayId()});
                return new MergeContinue();
            }
            log.debug("{}: Attempting to cascade merge {} to {}", new Object[]{this.repository, this.source.getDisplayId(), this.destination.getDisplayId()});
            try {
                int attempt = 1;
                while (true) {
                    try {
                        return this.attemptMerge();
                    }
                    catch (MergeException e) {
                        this.handleMergeFailed(attempt, e);
                        ++attempt;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.info("{}: Cascading merging {} to {} failed", new Object[]{this.repository, this.source.getDisplayId(), this.destination.getDisplayId(), log.isDebugEnabled() ? e : null});
                return new MergeStopped(new MergeFailedReason());
            }
        }

        @Nonnull
        private MergeResult attemptMerge() {
            Command command = MergeAction.this.scmService.getExtendedCommandFactory(this.repository).merge(((MergeCommandParameters.Builder)((MergeCommandParameters.Builder)((MergeCommandParameters.Builder)((MergeCommandParameters.Builder)((MergeCommandParameters.Builder)new MergeCommandParameters.Builder().author(this.currentUser)).fromBranch(this.source.getId())).message(String.format("Cascading merge from %1$s -> %2$s", this.source.getDisplayId(), this.destination.getDisplayId()))).toBranch(this.destination.getId())).toCommitId(this.destination.getLatestCommit())).build());
            command.setTimeout(MergeAction.this.config.getTimeout());
            Branch updatedBranch = (Branch)command.call();
            if (this.destination.getLatestCommit().equals(updatedBranch.getLatestCommit())) {
                log.debug("{}: No merge performed for {} to {} as all changes are already on the target branch", new Object[]{this.repository, this.source.getDisplayId(), this.destination.getDisplayId()});
                return new MergeContinue();
            }
            return new MergeSuccess((RefChange)((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().type(RefChangeType.UPDATE)).fromHash(this.destination.getLatestCommit())).to((Ref)updatedBranch)).build());
        }

        private void handleMergeFailed(int attempt, MergeException e) {
            if (!(e.getCause() instanceof GitNonFastForwardUpdateRejectedException)) {
                throw e;
            }
            if (attempt >= 3) {
                log.debug("{}: Giving up on merging {} to {} after {} attempts", new Object[]{this.repository, this.source.getDisplayId(), this.destination.getDisplayId(), 3});
                throw e;
            }
            log.debug("{}: Merge failed because new changes were pushed to {} while the merge was being performed (attempt {}/{})", new Object[]{this.repository, this.destination.getDisplayId(), attempt, 3});
            this.destination = (Ref)MergeAction.this.scmService.getCommandFactory(this.repository).resolveRef(new ResolveRefCommandParameters.Builder(this.destination.getId()).type((RefType)StandardRefType.BRANCH).build()).call();
        }
    }
}

