/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge;

import com.atlassian.bitbucket.internal.branch.cascadingmerge.BranchProcessor;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMergeProcessor;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.MergeInstruction;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeContinue;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeResult;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.MergeStopped;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.OpenPullRequestReason;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=1)
public class NoOpenPullRequests
implements BranchProcessor {
    private static final Logger log = LoggerFactory.getLogger(CascadingMergeProcessor.class);
    private final PullRequestService pullRequestService;

    public NoOpenPullRequests(PullRequestService pullRequestService) {
        this.pullRequestService = pullRequestService;
    }

    @Override
    public MergeResult process(MergeInstruction mergeInstruction) {
        Repository repository = mergeInstruction.getRepository();
        Branch source = mergeInstruction.getSource();
        Branch destination = mergeInstruction.getDestination();
        PullRequestSearchRequest searchRequest = new PullRequestSearchRequest.Builder().fromRefId(source.getId()).fromRepositoryId(Integer.valueOf(repository.getId())).order(PullRequestOrder.OLDEST).state(PullRequestState.OPEN).toRefId(destination.getId()).toRepositoryId(Integer.valueOf(repository.getId())).withProperties(false).build();
        Page page = this.pullRequestService.search(searchRequest, PageUtils.newRequest((int)0, (int)1));
        PullRequest pullRequest = (PullRequest)Iterables.getOnlyElement((Iterable)page.getValues(), null);
        if (pullRequest == null) {
            return new MergeContinue();
        }
        if (!mergeInstruction.isDryRun()) {
            log.info("{}: Not auto-merging {} to {} because doing so would merge pull request {} as well", new Object[]{repository, source.getDisplayId(), destination.getDisplayId(), pullRequest.getId()});
        }
        return new MergeStopped(new OpenPullRequestReason(pullRequest));
    }
}

