/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge;

import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMerge;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMergeStatus;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.StopReason;
import com.atlassian.bitbucket.repository.Branch;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SimpleCascadingMerge
implements CascadingMerge {
    private final Iterable<Branch> path;
    private final CascadingMergeStatus status;
    private final StopReason stopReason;

    private SimpleCascadingMerge(Builder builder) {
        this.path = builder.path;
        this.status = builder.status;
        this.stopReason = builder.stopReason;
    }

    private SimpleCascadingMerge(CascadingMergeStatus status, Iterable<Branch> path) {
        this.status = status;
        this.path = path;
        this.stopReason = null;
    }

    public static CascadingMerge proceed(Iterable<Branch> path) {
        return new SimpleCascadingMerge(CascadingMergeStatus.PROCEED, Objects.requireNonNull(path, "path"));
    }

    public static CascadingMerge skip(CascadingMergeStatus reason, Branch branch) {
        CascadingMergeStatus status = Objects.requireNonNull(reason, "reason");
        Set<Branch> path = Collections.singleton(Objects.requireNonNull(branch, "branch"));
        return new SimpleCascadingMerge(status, path);
    }

    @Override
    @Nonnull
    public Iterable<Branch> getPath() {
        return this.path;
    }

    @Override
    @Nonnull
    public CascadingMergeStatus getStatus() {
        return this.status;
    }

    @Override
    @Nonnull
    public Optional<StopReason> getStopReason() {
        return Optional.ofNullable(this.stopReason);
    }

    public static final class Builder {
        private final Iterable<Branch> path;
        private final CascadingMergeStatus status;
        private StopReason stopReason;

        public Builder(CascadingMergeStatus status, Iterable<Branch> path) {
            this.path = path;
            this.status = status;
        }

        public CascadingMerge build() {
            return new SimpleCascadingMerge(this);
        }

        public Builder truncated(StopReason stopReason) {
            this.stopReason = stopReason;
            return this;
        }
    }
}

