/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration;

import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfigurationRequest;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public final class CascadingMergeConfiguration {
    private final boolean enabled;
    private final boolean mergeCheckEnabled;

    private CascadingMergeConfiguration(Builder builder) {
        this.enabled = builder.enabled;
        this.mergeCheckEnabled = builder.mergeCheckEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CascadingMergeConfiguration that = (CascadingMergeConfiguration)o;
        return this.enabled == that.enabled && this.mergeCheckEnabled == that.mergeCheckEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.mergeCheckEnabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMergeCheckEnabled() {
        return this.mergeCheckEnabled;
    }

    public static final class Builder {
        private boolean enabled;
        private boolean mergeCheckEnabled;

        public Builder(@Nonnull CascadingMergeConfigurationRequest request) {
            Objects.requireNonNull(request, "request");
            this.enabled = request.isEnabled();
            this.mergeCheckEnabled = request.isMergeCheckEnabled();
        }

        public Builder() {
        }

        @Nonnull
        public CascadingMergeConfiguration build() {
            return new CascadingMergeConfiguration(this);
        }

        @Nonnull
        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Nonnull
        public Builder mergeCheckEnabled(boolean mergeCheckEnabled) {
            this.mergeCheckEnabled = mergeCheckEnabled;
            return this;
        }
    }
}

