/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration;

import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfiguration;
import com.atlassian.bitbucket.scope.Scope;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public final class CascadingMergeConfigurationRequest {
    private final boolean enabled;
    private final boolean mergeCheckEnabled;
    private final Scope scope;

    private CascadingMergeConfigurationRequest(Builder builder) {
        this.enabled = builder.enabled;
        this.mergeCheckEnabled = builder.mergeCheckEnabled;
        this.scope = builder.scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CascadingMergeConfigurationRequest that = (CascadingMergeConfigurationRequest)o;
        return this.enabled == that.enabled && this.mergeCheckEnabled == that.mergeCheckEnabled && Objects.equals(this.scope, that.scope);
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.mergeCheckEnabled, this.scope);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMergeCheckEnabled() {
        return this.mergeCheckEnabled;
    }

    public static final class Builder {
        private final Scope scope;
        private boolean enabled;
        private boolean mergeCheckEnabled;

        public Builder(@Nonnull Scope scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
        }

        public Builder(@Nonnull Scope scope, @Nonnull CascadingMergeConfiguration configuration) {
            this.scope = Objects.requireNonNull(scope, "scope");
            Objects.requireNonNull(configuration, "configuration");
            this.enabled = configuration.isEnabled();
            this.mergeCheckEnabled = configuration.isMergeCheckEnabled();
        }

        @Nonnull
        public CascadingMergeConfigurationRequest build() {
            return new CascadingMergeConfigurationRequest(this);
        }

        @Nonnull
        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Nonnull
        public Builder mergeCheckEnabled(boolean mergeCheckEnabled) {
            this.mergeCheckEnabled = mergeCheckEnabled;
            return this;
        }
    }
}

