/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration;

import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfigurationService;
import com.atlassian.bitbucket.event.project.ProjectDeletionRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.branch.BranchRestrictionScopeHelper;
import com.atlassian.bitbucket.internal.branch.ScopeValidationService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfiguration;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfigurationRequest;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfigurationService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.dao.CascadingMergeConfigDao;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.event.CascadingMergeConfigUpdatedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class DefaultCascadingMergeConfigurationService
implements CascadingMergeConfigurationService {
    static final int DEFAULT_LIMIT = 30;
    static final long DEFAULT_TIMEOUT = TimeUnit.MINUTES.toSeconds(5L);
    static final String LEGACY_SETTINGS_KEY = "com.atlassian.bitbucket.server.bitbucket-auto-merge";
    static final String PROP_PREFIX = "plugin.bitbucket-cascading-merge.";
    static final String PROP_LIMIT = "plugin.bitbucket-cascading-merge.limit";
    static final String PROP_TIMEOUT = "plugin.bitbucket-cascading-merge.timeout";
    static final String SETTING_ENABLED_PREFIX = "enabled.";
    private static final CascadingMergeConfiguration DEFAULT_CONFIGURATION = new CascadingMergeConfiguration.Builder().build();
    private final ApplicationPropertiesService applicationPropertiesService;
    private final BranchModelConfigurationService branchModelConfigurationService;
    private final BranchRestrictionScopeHelper branchRestrictionScopeHelper;
    private final CascadingMergeConfigDao cascadingMergeConfigDao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PluginSettings pluginSettings;
    private final ScopeValidationService scopeValidationService;
    private final TransactionTemplate transactionTemplate;
    private final EscalatedSecurityContext withProjectAdmin;

    public DefaultCascadingMergeConfigurationService(ApplicationPropertiesService applicationPropertiesService, BranchModelConfigurationService branchModelConfigurationService, BranchRestrictionScopeHelper branchRestrictionScopeHelper, CascadingMergeConfigDao cascadingMergeConfigDao, EventPublisher eventPublisher, I18nService i18nService, PluginSettingsFactory pluginSettingsFactory, SecurityService securityService, ScopeValidationService scopeValidationService, TransactionTemplate transactionTemplate) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.branchModelConfigurationService = branchModelConfigurationService;
        this.branchRestrictionScopeHelper = branchRestrictionScopeHelper;
        this.cascadingMergeConfigDao = cascadingMergeConfigDao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(LEGACY_SETTINGS_KEY);
        this.scopeValidationService = scopeValidationService;
        this.transactionTemplate = transactionTemplate;
        this.withProjectAdmin = securityService.withPermission(Permission.PROJECT_ADMIN, "cascading merge configuration");
    }

    @Override
    @Nonnull
    public CascadingMergeConfiguration getConfiguration(@Nonnull Scope scope) {
        BranchRestrictionScopeHelper.validateScopeType(scope, String.format("Cascading merge can not be configured at a %s level scope.", scope.getType()));
        this.validateNotPersonalProject(scope);
        this.scopeValidationService.validateReadPermission(scope, "bitbucket.branchmodel.cascadingmerge.error.invalidscope");
        return (CascadingMergeConfiguration)this.withProjectAdmin.call(() -> {
            BranchModelConfiguration branchModelConfiguration = this.branchModelConfigurationService.getConfiguration(scope);
            return (CascadingMergeConfiguration)this.transactionTemplate.execute(() -> this.cascadingMergeConfigDao.get(branchModelConfiguration.getScope()).orElseGet(() -> (CascadingMergeConfiguration)branchModelConfiguration.getScope().accept((ScopeVisitor)new ScopeVisitor<CascadingMergeConfiguration>(){

                public CascadingMergeConfiguration visit(@Nonnull ProjectScope scope) {
                    return DEFAULT_CONFIGURATION;
                }

                public CascadingMergeConfiguration visit(@Nonnull RepositoryScope scope) {
                    return DefaultCascadingMergeConfigurationService.this.setConfiguration(new CascadingMergeConfigurationRequest.Builder((Scope)scope).enabled(Objects.equals("true", DefaultCascadingMergeConfigurationService.this.pluginSettings.get(DefaultCascadingMergeConfigurationService.settingKeyFor(scope.getRepository())))).mergeCheckEnabled(false).build());
                }
            })));
        });
    }

    @Override
    public int getLimit() {
        return this.applicationPropertiesService.getPluginProperty(PROP_LIMIT, 30);
    }

    @Override
    public long getTimeout() {
        return this.applicationPropertiesService.getPluginProperty(PROP_TIMEOUT, DEFAULT_TIMEOUT);
    }

    @EventListener
    public void onProjectDeletionRequested(@Nonnull ProjectDeletionRequestedEvent event) {
        Objects.requireNonNull(event, "projectDeletedEvent");
        if (!event.isCanceled()) {
            this.cascadingMergeConfigDao.delete((Scope)Scopes.project((Project)event.getProject()));
        }
    }

    @EventListener
    public void onRepositoryDeletionRequested(@Nonnull RepositoryDeletionRequestedEvent event) {
        Objects.requireNonNull(event, "repositoryDeletedEvent");
        if (!event.isCanceled()) {
            Repository repository = event.getRepository();
            this.pluginSettings.remove(DefaultCascadingMergeConfigurationService.settingKeyFor(repository));
            this.cascadingMergeConfigDao.delete((Scope)Scopes.repository((Repository)repository));
        }
    }

    @Override
    @Nonnull
    public CascadingMergeConfiguration setConfiguration(@Nonnull CascadingMergeConfigurationRequest request) {
        Objects.requireNonNull(request, "request");
        Scope scope = request.getScope();
        BranchRestrictionScopeHelper.validateScopeType(scope, String.format("Cascading merge can not be configured at a %s level scope.", scope.getType()));
        this.validateNotPersonalProject(scope);
        this.scopeValidationService.validateAdminPermission(scope, "bitbucket.branchmodel.cascadingmerge.error.invalidscope");
        this.branchRestrictionScopeHelper.validateNotRestricted(scope, "bitbucket.branchmodel.error.update.restricted");
        if (!request.isEnabled() && request.isMergeCheckEnabled()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.branchmodel.cascadingmerge.mergecheck.error.invalid", new Object[0]));
        }
        Optional oldConfig = (Optional)this.transactionTemplate.execute(() -> this.cascadingMergeConfigDao.get(scope));
        CascadingMergeConfiguration newConfig = (CascadingMergeConfiguration)this.transactionTemplate.execute(() -> this.cascadingMergeConfigDao.set(scope, new CascadingMergeConfiguration.Builder(request).build()));
        oldConfig.ifPresent(config -> {
            if (!newConfig.equals(config)) {
                this.eventPublisher.publish((Object)new CascadingMergeConfigUpdatedEvent(this, scope, newConfig, (CascadingMergeConfiguration)config));
            }
        });
        this.removeOldSettings(scope);
        return newConfig;
    }

    private static String settingKeyFor(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return SETTING_ENABLED_PREFIX + repository.getId();
    }

    private void removeOldSettings(@Nonnull Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull RepositoryScope scope) {
                DefaultCascadingMergeConfigurationService.this.pluginSettings.remove(DefaultCascadingMergeConfigurationService.settingKeyFor(scope.getRepository()));
                return null;
            }
        });
    }

    private void validateNotPersonalProject(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                if (scope.getProject().getType() == ProjectType.PERSONAL) {
                    throw new ArgumentValidationException(DefaultCascadingMergeConfigurationService.this.i18nService.createKeyedMessage("bitbucket.cascadingmerge.error.personalproject", new Object[0]));
                }
                return null;
            }
        });
    }
}

