/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfiguration;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.dao.AoScopeCascadingMergeConfig;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.dao.CascadingMergeConfigDao;
import com.atlassian.bitbucket.scope.Scope;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import net.java.ao.RawEntity;

public class AoCascadingMergeConfigDao
extends AbstractAoDao
implements CascadingMergeConfigDao {
    private static final String SCOPE_QUERY = "RESOURCE_ID = ? AND SCOPE_TYPE = ?";

    public AoCascadingMergeConfigDao(@Nonnull ActiveObjects ao) {
        super(ao);
    }

    @Override
    public void delete(@Nonnull Scope scope) {
        this.getAoConfig(scope).ifPresent(xva$0 -> this.ao.delete(new RawEntity[]{xva$0}));
    }

    @Override
    public Optional<CascadingMergeConfiguration> get(@Nonnull Scope scope) {
        return this.getAoConfig(scope).map(existing -> new CascadingMergeConfiguration.Builder().enabled(existing.isEnabled()).mergeCheckEnabled(existing.isMergeCheckEnabled()).build());
    }

    @Override
    public CascadingMergeConfiguration set(@Nonnull Scope scope, @Nonnull CascadingMergeConfiguration configuration) {
        this.delete(scope);
        ImmutableMap.Builder build = ImmutableMap.builder().put((Object)"SCOPE_TYPE", (Object)scope.getType()).put((Object)"ENABLED", (Object)configuration.isEnabled()).put((Object)"MERGE_CHECK_ENABLED", (Object)configuration.isMergeCheckEnabled()).put((Object)"RESOURCE_ID", scope.getResourceId().orElseThrow(() -> new UnsupportedOperationException("Cascading merge configuration cannot be managed at Global scope")));
        this.ao.create(AoScopeCascadingMergeConfig.class, (Map)build.build());
        return configuration;
    }

    private Optional<AoScopeCascadingMergeConfig> getAoConfig(@Nonnull Scope scope) {
        return scope.getResourceId().flatMap(resourceId -> {
            AoScopeCascadingMergeConfig[] configurations = (AoScopeCascadingMergeConfig[])this.ao.find(AoScopeCascadingMergeConfig.class, SCOPE_QUERY, new Object[]{resourceId, scope.getType()});
            return Arrays.stream(configurations).findFirst();
        });
    }
}

