/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge.mergecheck;

import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryMergeCheck;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMerge;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMergeService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfiguration;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfigurationService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.OpenPullRequestReason;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import jakarta.annotation.Nonnull;

public class CascadingMergeOpenDownstreamPullRequestCheck
implements RepositoryMergeCheck {
    private final CascadingMergeConfigurationService cascadingMergeConfigurationService;
    private final CascadingMergeService cascadingMergeService;
    private final I18nService i18nService;

    public CascadingMergeOpenDownstreamPullRequestCheck(CascadingMergeService cascadingMergeService, CascadingMergeConfigurationService cascadingMergeConfigurationService, I18nService i18nService) {
        this.cascadingMergeService = cascadingMergeService;
        this.cascadingMergeConfigurationService = cascadingMergeConfigurationService;
        this.i18nService = i18nService;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull PullRequestMergeHookRequest request) {
        CascadingMergeConfiguration configuration = this.cascadingMergeConfigurationService.getConfiguration((Scope)Scopes.repository((Repository)request.getRepository()));
        if (!configuration.isMergeCheckEnabled()) {
            return RepositoryHookResult.accepted();
        }
        PullRequestRef ref = request.getPullRequest().getToRef();
        Repository repository = ref.getRepository();
        CascadingMerge cascadingMergeInfo = this.cascadingMergeService.getCascadingMerge(repository, (Ref)ref);
        if (!cascadingMergeInfo.getStatus().isAvailable()) {
            return RepositoryHookResult.accepted();
        }
        return cascadingMergeInfo.getStopReason().filter(stopReason -> stopReason instanceof OpenPullRequestReason).map(stopReason -> (OpenPullRequestReason)stopReason).map(stopReason -> {
            PullRequest pullRequest = stopReason.getPullRequest();
            String idString = String.valueOf(pullRequest.getId());
            return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.branch.mergecheck.downstream.summaryMessage", new Object[]{idString}), (String)this.i18nService.getMessage("bitbucket.branch.mergecheck.downstream.detailedMessage", new Object[]{idString, pullRequest.getAuthor().getUser().getDisplayName()}));
        }).orElse(RepositoryHookResult.accepted());
    }
}

