/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfigurationRequest;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfigurationService;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
public class BaseCascadingMergeConfigResource {
    protected final CascadingMergeConfigurationService cascadingMergeConfigService;
    protected final I18nService i18nService;

    public BaseCascadingMergeConfigResource(I18nService i18nService, CascadingMergeConfigurationService cascadingMergeConfigService) {
        this.cascadingMergeConfigService = cascadingMergeConfigService;
        this.i18nService = i18nService;
    }

    @DELETE
    @Path(value="enabled")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response disableCascadingMerge(@BeanParam ScopeResolver scopeResolver) {
        this.cascadingMergeConfigService.setConfiguration(new CascadingMergeConfigurationRequest.Builder(scopeResolver.getScope()).enabled(false).mergeCheckEnabled(false).build());
        return ResponseFactory.noContent().build();
    }

    @PUT
    @Path(value="enabled")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response enableCascadingMerge(@BeanParam ScopeResolver scopeResolver) {
        this.cascadingMergeConfigService.setConfiguration(new CascadingMergeConfigurationRequest.Builder(scopeResolver.getScope()).enabled(true).build());
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="enabled")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response isCascadingMergeEnabled(@BeanParam ScopeResolver scopeResolver) {
        return this.cascadingMergeConfigService.getConfiguration(scopeResolver.getScope()).isEnabled() ? ResponseFactory.ok().build() : ResponseFactory.notFound().build();
    }
}

