/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMergeService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfigurationService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.rest.BaseCascadingMergeConfigResource;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.rest.RestCascadingMerge;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;

@Path(value="projects/{projectKey}/repos/{repositorySlug}/automerge")
@Provider
@Singleton
@LicensedOnly
public class CascadingMergeRepositoryResource
extends BaseCascadingMergeConfigResource {
    private final CascadingMergeService cascadingMergeService;
    private final RefService refService;

    @Inject
    public CascadingMergeRepositoryResource(I18nService i18nService, CascadingMergeService cascadingMergeService, CascadingMergeConfigurationService cascadingMergeConfigService, RefService refService) {
        super(i18nService, cascadingMergeConfigService);
        this.cascadingMergeService = cascadingMergeService;
        this.refService = refService;
    }

    @GET
    @Path(value="path/{branchRefId:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMergePath(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="branchRefId") String branchRefId) {
        if (StringUtils.isBlank((CharSequence)branchRefId)) {
            return ResponseFactory.badRequest((String)"branchRefId", (String)this.i18nService.getMessage("bitbucket.branch.cascadingmerge.rest.error.emptybranchrefid", new Object[0])).build();
        }
        Branch branch = (Branch)this.refService.resolveRef(new ResolveRefRequest.Builder(repositoryResolver.getRepository()).refId(branchRefId).type((RefType)StandardRefType.BRANCH).build());
        if (branch == null) {
            return ResponseFactory.badRequest((String)"branchRefId", (String)this.i18nService.getMessage("bitbucket.branch.cascadingmerge.rest.error.nosuchbranch", new Object[]{branchRefId})).build();
        }
        return ResponseFactory.ok((Object)((Object)new RestCascadingMerge(this.cascadingMergeService.getCascadingMerge(repositoryResolver.getRepository(), (Ref)branch)))).build();
    }
}

