/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.cascadingmerge.rest;

import com.atlassian.bitbucket.internal.branch.cascadingmerge.CascadingMerge;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.rest.RestCascadingMergeStatus;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.result.OpenPullRequestReason;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.v2.api.repository.RestBranch;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Function;

@JsonSerialize
@JsonSurrogate(value=CascadingMerge.class)
public class RestCascadingMerge
extends RestMapEntity {
    public static final String DOWNSTREAM_PULL_REQUEST = "downstreamPullRequest";
    public static final String PATH = "path";
    public static final String STATUS = "status";
    public static final String STOP_REASON = "stopReason";

    public RestCascadingMerge() {
    }

    public RestCascadingMerge(@Nonnull CascadingMerge cascadingMerge) {
        Objects.requireNonNull(cascadingMerge, "cascadingMerge");
        this.put(STATUS, (Object)new RestCascadingMergeStatus(cascadingMerge.getStatus()));
        this.put(PATH, RestCascadingMerge.transform(cascadingMerge.getPath(), (Function)RestBranch.REST_TRANSFORM));
        this.putIfNotNull(STOP_REASON, cascadingMerge.getStopReason().map(stopReason -> stopReason.getApiReason().name()).orElse(null));
        this.putIfNotNull(DOWNSTREAM_PULL_REQUEST, cascadingMerge.getStopReason().filter(stopReason -> stopReason instanceof OpenPullRequestReason).map(stopReason -> ((OpenPullRequestReason)stopReason).getPullRequest()).map(RestPullRequest::new).orElse(null));
    }
}

