/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.deleteaftermerge;

import com.atlassian.bitbucket.event.project.ProjectDeletionRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.branch.BranchRestrictionScopeHelper;
import com.atlassian.bitbucket.internal.branch.ScopeValidationService;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.DeleteAfterMergeConfiguration;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.DeleteAfterMergeConfigurationRequest;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.DeleteAfterMergeConfigurationService;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.dao.DeleteAfterMergeConfigDao;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.event.DeleteAfterMergeConfigCreatedEvent;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.event.DeleteAfterMergeConfigDeletedEvent;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.event.DeleteAfterMergeConfigUpdatedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class DefaultDeleteAfterMergeConfigurationService
implements DeleteAfterMergeConfigurationService {
    private final BranchRestrictionScopeHelper branchRestrictionScopeHelper;
    private final DeleteAfterMergeConfigDao deleteAfterConfigDao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final ScopeValidationService scopeValidationService;
    private final TransactionTemplate transactionTemplate;

    public DefaultDeleteAfterMergeConfigurationService(BranchRestrictionScopeHelper branchRestrictionScopeHelper, DeleteAfterMergeConfigDao deleteAfterConfigDao, EventPublisher eventPublisher, I18nService i18nService, ScopeValidationService scopeValidationService, TransactionTemplate transactionTemplate) {
        this.branchRestrictionScopeHelper = branchRestrictionScopeHelper;
        this.deleteAfterConfigDao = deleteAfterConfigDao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.scopeValidationService = scopeValidationService;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public void deleteConfiguration(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        if (scope.getType() != ScopeType.REPOSITORY) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.branch.deleteaftermerge.error.invalidscope", new Object[]{scope.getType()}));
        }
        this.scopeValidationService.validateAdminPermission(scope, "bitbucket.branch.deleteaftermerge.error.invalidpermission");
        this.branchRestrictionScopeHelper.validateNotRestricted(scope, "bitbucket.branchmodel.error.deletion.restricted");
        this.deleteAfterConfigDao.isEnabled(scope).ifPresent(isEnabled -> {
            this.deleteAfterConfigDao.delete(scope);
            this.eventPublisher.publish((Object)new DeleteAfterMergeConfigDeletedEvent(this, new DeleteAfterMergeConfiguration((boolean)isEnabled), scope));
        });
    }

    @Override
    @Nonnull
    public DeleteAfterMergeConfiguration getConfiguration(@Nonnull Scope scope) {
        this.validateScope(scope);
        this.scopeValidationService.validateReadPermission(scope, "bitbucket.branch.deleteaftermerge.error.invalidpermission");
        Scope unrestrictedScope = this.branchRestrictionScopeHelper.getUnrestrictedScope(scope);
        boolean enabled = (Boolean)this.transactionTemplate.execute(() -> this.deleteAfterConfigDao.isEnabled(unrestrictedScope).orElseGet(() -> (Boolean)unrestrictedScope.accept((ScopeVisitor)new ScopeVisitor<Boolean>(){

            public Boolean visit(@Nonnull ProjectScope scope) {
                return false;
            }

            public Boolean visit(@Nonnull RepositoryScope scope) {
                return DefaultDeleteAfterMergeConfigurationService.this.deleteAfterConfigDao.isEnabled((Scope)Scopes.project((Project)scope.getRepository().getProject())).orElse(false);
            }
        })));
        return new DeleteAfterMergeConfiguration(enabled);
    }

    @EventListener
    public void onProjectDeletionRequested(@Nonnull ProjectDeletionRequestedEvent event) {
        Objects.requireNonNull(event, "projectDeletedEvent");
        if (!event.isCanceled()) {
            this.deleteAfterConfigDao.delete((Scope)Scopes.project((Project)event.getProject()));
        }
    }

    @EventListener
    public void onRepositoryDeletionRequested(@Nonnull RepositoryDeletionRequestedEvent event) {
        Objects.requireNonNull(event, "repositoryDeletedEvent");
        if (!event.isCanceled()) {
            this.deleteAfterConfigDao.delete((Scope)Scopes.repository((Repository)event.getRepository()));
        }
    }

    @Override
    public void setConfiguration(@Nonnull DeleteAfterMergeConfigurationRequest request) {
        Objects.requireNonNull(request, "request");
        Scope scope = request.getScope();
        this.validateScope(scope);
        this.scopeValidationService.validateAdminPermission(scope, "bitbucket.branch.deleteaftermerge.error.invalidpermission");
        this.branchRestrictionScopeHelper.validateNotRestricted(scope, "bitbucket.branchmodel.error.update.restricted");
        this.transactionTemplate.execute(() -> {
            Optional<Boolean> previousEnabled = this.deleteAfterConfigDao.isEnabled(scope);
            this.deleteAfterConfigDao.setEnabled(request.isEnabled(), scope);
            if (!previousEnabled.isPresent()) {
                this.eventPublisher.publish((Object)new DeleteAfterMergeConfigCreatedEvent(this, new DeleteAfterMergeConfiguration(request.isEnabled()), scope));
            } else if (previousEnabled.get().booleanValue() != request.isEnabled()) {
                DeleteAfterMergeConfiguration previousConfiguration = new DeleteAfterMergeConfiguration(previousEnabled.get());
                DeleteAfterMergeConfiguration newConfiguration = new DeleteAfterMergeConfiguration(request.isEnabled());
                this.eventPublisher.publish((Object)new DeleteAfterMergeConfigUpdatedEvent(this, newConfiguration, previousConfiguration, scope));
            }
            return null;
        });
    }

    private void validateScope(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull GlobalScope scope) {
                throw new ArgumentValidationException(DefaultDeleteAfterMergeConfigurationService.this.i18nService.createKeyedMessage("bitbucket.branch.deleteaftermerge.error.invalidscope", new Object[]{scope.getType()}));
            }

            public Void visit(@Nonnull ProjectScope scope) {
                if (scope.getProject().getType() == ProjectType.PERSONAL) {
                    throw new ArgumentValidationException(DefaultDeleteAfterMergeConfigurationService.this.i18nService.createKeyedMessage("bitbucket.branch.deleteaftermerge.error.personalproject", new Object[0]));
                }
                return null;
            }
        });
    }
}

