/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.deleteaftermerge.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.dao.AoScopeDeleteAfterMergeConfig;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.dao.DeleteAfterMergeConfigDao;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;

public class AoDeleteAfterMergeConfigDao
extends AbstractAoDao
implements DeleteAfterMergeConfigDao {
    private static final int DELETE_ALL_MAX_SIZE = 1000;
    private static final String SCOPE_QUERY = "RESOURCE_ID = ? AND SCOPE_TYPE = ?";

    public AoDeleteAfterMergeConfigDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    public void delete(@Nonnull Scope scope) {
        this.getAoConfig(scope).ifPresent(xva$0 -> this.ao.delete(new RawEntity[]{xva$0}));
    }

    @Override
    public void deleteAll(@Nonnull List<Integer> repositoryIds) {
        if (repositoryIds.isEmpty()) {
            return;
        }
        if (repositoryIds.size() > 1000) {
            throw new IllegalArgumentException("Repository ids cannot exceed 1000 entries.");
        }
        String query = "RESOURCE_ID" + " IN (" + StringUtils.repeat((String)"?", (String)",", (int)repositoryIds.size()) + ") AND " + "SCOPE_TYPE" + " = ?";
        Object[] parameters = repositoryIds.toArray(new Object[repositoryIds.size() + 1]);
        parameters[repositoryIds.size()] = ScopeType.REPOSITORY;
        this.ao.deleteWithSQL(AoScopeDeleteAfterMergeConfig.class, query, parameters);
    }

    @Override
    @Nonnull
    public Optional<Boolean> isEnabled(@Nonnull Scope scope) {
        return this.getAoConfig(scope).map(config -> config.isEnabled());
    }

    @Override
    public void setEnabled(boolean enabled, @Nonnull Scope scope) {
        this.delete(scope);
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"SCOPE_TYPE", (Object)scope.getType()).put((Object)"ENABLED", (Object)enabled).put((Object)"RESOURCE_ID", scope.getResourceId().orElseThrow(() -> new UnsupportedOperationException("Delete after merge configuration cannot be managed at Global scope")));
        this.ao.create(AoScopeDeleteAfterMergeConfig.class, (Map)builder.build());
    }

    private Optional<AoScopeDeleteAfterMergeConfig> getAoConfig(@Nonnull Scope scope) {
        Integer resourceId = (Integer)scope.getResourceId().orElseThrow(() -> new UnsupportedOperationException("Delete after merge configuration cannot be managed at Global scope"));
        AoScopeDeleteAfterMergeConfig[] configurations = (AoScopeDeleteAfterMergeConfig[])this.ao.find(AoScopeDeleteAfterMergeConfig.class, SCOPE_QUERY, new Object[]{resourceId, scope.getType()});
        return Arrays.stream(configurations).findFirst();
    }
}

