/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.deleteaftermerge.event;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.bitbucket.audit.AuditEventConverter;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.event.DeleteAfterMergeConfigEvent;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.event.DeleteAfterMergeConfigUpdatedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.util.AuditUtils;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class DeleteAfterMergeConfigEventConverter
implements AuditEventConverter<DeleteAfterMergeConfigEvent> {
    static final String ATTR_ENABLED = "bitbucket.branch.audit.action.deleteaftermerge.enabled";

    @Nonnull
    public AuditEvent convert(@Nonnull DeleteAfterMergeConfigEvent event, final @Nonnull AuditEvent.Builder builder) {
        Objects.requireNonNull(event, "event");
        Objects.requireNonNull(builder, "builder");
        event.getScope().accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                builder.categoryI18nKey("bitbucket.service.audit.category.projects").affectedObject(AuditUtils.auditResourceForProject((Project)scope.getProject()));
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                builder.categoryI18nKey("bitbucket.service.audit.category.repositories").affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)scope.getRepository()));
                return null;
            }
        });
        if (event instanceof DeleteAfterMergeConfigUpdatedEvent) {
            return DeleteAfterMergeConfigEventConverter.addChangedValues((DeleteAfterMergeConfigUpdatedEvent)event, builder).build();
        }
        return DeleteAfterMergeConfigEventConverter.addExtraAttributes(event, builder).build();
    }

    private static AuditEvent.Builder addChangedValues(DeleteAfterMergeConfigUpdatedEvent event, AuditEvent.Builder builder) {
        return builder.addChangedValueIfDifferent(new ChangedValue.Builder(ATTR_ENABLED).from(String.valueOf(event.getPreviousEnabled())).to(String.valueOf(event.isEnabled())).build());
    }

    private static AuditEvent.Builder addExtraAttributes(DeleteAfterMergeConfigEvent event, AuditEvent.Builder builder) {
        return builder.extraAttribute(new AuditAttribute.Builder(ATTR_ENABLED, String.valueOf(event.isEnabled())).build());
    }
}

