/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.deleteaftermerge.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.DeleteAfterMergeConfiguration;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.DeleteAfterMergeConfigurationRequest;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.DeleteAfterMergeConfigurationService;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.rest.RestDeleteAfterMergeConfiguration;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
public abstract class AbstractDeleteAfterMergeResource {
    private final DeleteAfterMergeConfigurationService deleteAfterMergeConfigurationService;

    public AbstractDeleteAfterMergeResource(DeleteAfterMergeConfigurationService deleteAfterMergeConfigurationService) {
        this.deleteAfterMergeConfigurationService = deleteAfterMergeConfigurationService;
    }

    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateConfiguration(@BeanParam ScopeResolver scopeResolver, RestDeleteAfterMergeConfiguration request) {
        DeleteAfterMergeConfigurationRequest configuration = new DeleteAfterMergeConfigurationRequest(request.isEnabled(), scopeResolver.getScope());
        this.deleteAfterMergeConfigurationService.setConfiguration(configuration);
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteConfiguration(@BeanParam ScopeResolver scopeResolver) {
        this.deleteAfterMergeConfigurationService.deleteConfiguration(scopeResolver.getScope());
        return ResponseFactory.noContent().build();
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response isDeleteAfterMergeEnabled(@BeanParam ScopeResolver scopeResolver) {
        DeleteAfterMergeConfiguration result = this.deleteAfterMergeConfigurationService.getConfiguration(scopeResolver.getScope());
        return ResponseFactory.ok((Object)((Object)new RestDeleteAfterMergeConfiguration(result))).build();
    }
}

