/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.info;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class BranchInfoRequest {
    private final Repository repository;
    private final String commit;
    private final PageRequest pageRequest;
    private final List<MinimalRef> branches;

    public BranchInfoRequest(@Nonnull Repository repository, @Nonnull String commit, @Nonnull PageRequest pageRequest, @Nonnull List<MinimalRef> branches) {
        this.repository = Objects.requireNonNull(repository, "repository");
        this.commit = Objects.requireNonNull(commit, "commit");
        this.pageRequest = Objects.requireNonNull(pageRequest, "pageRequest");
        this.branches = ImmutableList.copyOf((Collection)Objects.requireNonNull(branches, "branches"));
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public String getCommit() {
        return this.commit;
    }

    @Nonnull
    public PageRequest getPageRequest() {
        return this.pageRequest;
    }

    @Nonnull
    public List<MinimalRef> getBranches() {
        return this.branches;
    }
}

