/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.info.git;

import com.atlassian.bitbucket.dmz.process.LineStdoutHandler;
import com.atlassian.bitbucket.internal.branch.info.BranchInfoRequest;
import com.atlassian.bitbucket.internal.branch.info.BranchInformation;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitScmCommandBuilder;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class GitBranchInformation
implements BranchInformation {
    private static final String PROPERTY_TIMEOUT = "plugin.bitbucket-branch-information.timeout";
    private final GitCommandBuilderFactory cmdBuilderFactory;
    private final int timeout;

    public GitBranchInformation(GitCommandBuilderFactory cmdBuilderFactory, ApplicationPropertiesService propertiesService) {
        this.cmdBuilderFactory = cmdBuilderFactory;
        this.timeout = propertiesService.getPluginProperty(PROPERTY_TIMEOUT, 5);
    }

    @Override
    @Deprecated
    public Page<MinimalRef> getBranches(BranchInfoRequest request) {
        if (!"git".equals(request.getRepository().getScmId())) {
            return PageUtils.createEmptyPage((PageRequest)request.getPageRequest());
        }
        GitScmCommandBuilder cmdBuilder = (GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)this.cmdBuilderFactory.builder(request.getRepository()).command("branch")).argument("--no-color")).argument("--contains")).argument(request.getCommit());
        if (!request.getBranches().isEmpty()) {
            cmdBuilder.argument("--list");
            cmdBuilder.argument("--");
            for (MinimalRef branch : request.getBranches()) {
                cmdBuilder.argument(GitRefPattern.HEADS.unqualify(branch.getId()));
            }
        }
        GitCommand cmd = cmdBuilder.build((CommandOutputHandler)new BranchStdoutHandler(request.getPageRequest()));
        cmd.setTimeout((long)this.timeout);
        return (Page)cmd.call();
    }

    @Deprecated
    private static class BranchStdoutHandler
    extends LineStdoutHandler<Page<MinimalRef>> {
        private final List<MinimalRef> branches;
        private final PageRequest pageRequest;
        private int count;

        BranchStdoutHandler(PageRequest pageRequest) {
            super(StandardCharsets.UTF_8);
            this.pageRequest = pageRequest;
            this.branches = new ArrayList<MinimalRef>();
        }

        public Page<MinimalRef> getOutput() {
            return PageUtils.createPage(this.branches, (PageRequest)this.pageRequest);
        }

        protected boolean onStdout(@Nonnull String line, boolean truncated) {
            if (this.count++ >= this.pageRequest.getStart()) {
                String branch = line.substring(2);
                this.branches.add((MinimalRef)((SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().id(GitRefPattern.HEADS.qualify(branch))).displayId(branch)).type((RefType)StandardRefType.BRANCH).build());
            }
            return this.branches.size() <= this.pageRequest.getLimit();
        }
    }
}

