/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.list.aheadbehind;

import com.atlassian.bitbucket.commit.graph.BatchingTraversalCallback;
import com.atlassian.bitbucket.commit.graph.DelegatingTraversalCallback;
import com.atlassian.bitbucket.commit.graph.TraversalCallback;
import com.atlassian.bitbucket.internal.branch.list.aheadbehind.AheadBehindCount;
import com.atlassian.bitbucket.internal.branch.list.aheadbehind.AheadBehindTraversalCallback;
import com.atlassian.bitbucket.repository.Ref;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchingAheadBehindTraversalCallback
extends DelegatingTraversalCallback
implements Supplier<Map<Ref, AheadBehindCount>> {
    private final List<AheadBehindTraversalCallback> delegates;

    private BatchingAheadBehindTraversalCallback(TraversalCallback batch, List<AheadBehindTraversalCallback> delegates) {
        super(batch);
        this.delegates = delegates;
    }

    public Map<Ref, AheadBehindCount> get() {
        HashMap<Ref, AheadBehindCount> result = new HashMap<Ref, AheadBehindCount>();
        for (AheadBehindTraversalCallback delegate : this.delegates) {
            AheadBehindCount count = delegate.getCount();
            if (count == null) continue;
            result.put(delegate.getRef(), count);
        }
        return result;
    }

    public static BatchingAheadBehindTraversalCallback create(Ref baseRef, Iterable<Ref> refs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Ref ref : refs) {
            builder.add((Object)new AheadBehindTraversalCallback(baseRef, ref));
        }
        ImmutableList delegates = builder.build();
        return new BatchingAheadBehindTraversalCallback((TraversalCallback)new BatchingTraversalCallback((List)delegates), (List<AheadBehindTraversalCallback>)delegates);
    }
}

