/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model;

import com.atlassian.bitbucket.internal.branch.model.BranchModelNode;
import com.atlassian.bitbucket.repository.Branch;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BranchModelGraphBuilder {
    private final Branch root;
    private Map<Branch, List<Branch>> nodes = Maps.newHashMap();

    public BranchModelGraphBuilder(@Nonnull Branch root) {
        this.root = Objects.requireNonNull(root, "root");
        this.newNode(root);
    }

    public static BranchModelNode forSinglePath(@Nonnull Iterable<Branch> singlePath) {
        Objects.requireNonNull(singlePath, "singlePath");
        Iterator<Branch> pathIterator = singlePath.iterator();
        Preconditions.checkArgument((boolean)pathIterator.hasNext(), (Object)"singlePath cannot be empty");
        Branch from = pathIterator.next();
        BranchModelGraphBuilder builder = new BranchModelGraphBuilder(from);
        while (pathIterator.hasNext()) {
            Branch to = pathIterator.next();
            builder.addPath(from, to);
            from = to;
        }
        return builder.build();
    }

    public BranchModelGraphBuilder addPath(Branch from, Branch to) {
        if (!this.nodes.containsKey(from)) {
            throw new IllegalStateException("From node " + String.valueOf(from) + "is not yet in the graph");
        }
        if (this.nodes.containsKey(to)) {
            throw new IllegalStateException("To node " + String.valueOf(to) + " is already in the graph");
        }
        this.nodes.get(from).add(to);
        this.newNode(to);
        return this;
    }

    public BranchModelNode build() {
        return this.createNode(this.root);
    }

    private List<Branch> newNode(Branch root) {
        return this.nodes.put(root, Lists.newArrayList());
    }

    private BranchModelNode createNode(Branch branch) {
        ImmutableList.Builder downstreamNodes = ImmutableList.builder();
        for (Branch downstream : this.nodes.get(branch)) {
            downstreamNodes.add((Object)this.createNode(downstream));
        }
        return new SimpleBranchModelNode(branch, (Iterable<BranchModelNode>)downstreamNodes.build());
    }

    private static class SimpleBranchModelNode
    implements BranchModelNode {
        private final Branch branch;
        private final Iterable<BranchModelNode> downstream;
        private final boolean isLeaf;

        private SimpleBranchModelNode(Branch branch, Iterable<BranchModelNode> downstream) {
            this.branch = branch;
            this.downstream = downstream;
            this.isLeaf = Iterables.isEmpty(downstream);
        }

        @Override
        @Nonnull
        public Branch getBranch() {
            return this.branch;
        }

        @Override
        @Nonnull
        public Iterable<BranchModelNode> getDownstream() {
            return this.downstream;
        }

        @Override
        public boolean isLeaf() {
            return this.isLeaf;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("branch", (Object)this.branch.getId()).add("downstream", this.downstream).toString();
        }
    }
}

