/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.branch.model.BranchModel;
import com.atlassian.bitbucket.branch.model.BranchModelService;
import com.atlassian.bitbucket.branch.model.BranchType;
import com.atlassian.bitbucket.branch.model.configuration.BranchConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfigurationException;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfigurationRequest;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfigurationService;
import com.atlassian.bitbucket.branch.model.configuration.BranchTypeConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.SimpleBranchTypeConfiguration;
import com.atlassian.bitbucket.event.project.ProjectCreatedEvent;
import com.atlassian.bitbucket.event.project.ProjectDeletionRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.branch.BranchRestrictionScopeHelper;
import com.atlassian.bitbucket.internal.branch.ScopeValidationService;
import com.atlassian.bitbucket.internal.branch.model.InternalBranchType;
import com.atlassian.bitbucket.internal.branch.model.InternalBranchTypes;
import com.atlassian.bitbucket.internal.branch.model.PrefixBranchClassifier;
import com.atlassian.bitbucket.internal.branch.model.SimpleBranchModel;
import com.atlassian.bitbucket.internal.branch.model.SimpleInternalBranchType;
import com.atlassian.bitbucket.internal.branch.model.configuration.SimpleBranchConfiguration;
import com.atlassian.bitbucket.internal.branch.model.configuration.SimpleBranchModelConfiguration;
import com.atlassian.bitbucket.internal.branch.model.dao.BranchModelDao;
import com.atlassian.bitbucket.internal.branch.model.event.BranchModelConfigurationCreatedEvent;
import com.atlassian.bitbucket.internal.branch.model.event.BranchModelConfigurationDeletedEvent;
import com.atlassian.bitbucket.internal.branch.model.event.BranchModelConfigurationUpdatedEvent;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.EmptyRepositoryException;
import com.atlassian.bitbucket.repository.InvalidRefNameException;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBranchModelService
implements BranchModelService,
BranchModelConfigurationService {
    @VisibleForTesting
    public static final String DEFAULT_VERSION_COMPONENT_SEPARATOR = "[_\\-.+]";
    private static final String BRANCHMODEL_PROP_PREFIX = "plugin.bitbucket-branch-model.";
    static final String PROP_PREFIX_MAX_LENGTH = "plugin.bitbucket-branch-model.validation.prefix.length";
    static final String PROP_VERSION_COMPONENT_SEPARATOR = "plugin.bitbucket-branch-model.version.separator";
    private static final int DEFAULT_PREFIX_MAX_LENGTH = 30;
    private static final String DEVELOPMENT_ID = "DEVELOPMENT";
    private static final String PRODUCTION_ID = "PRODUCTION";
    private static final Logger log = LoggerFactory.getLogger(DefaultBranchModelService.class);
    private final ActiveObjects ao;
    private final ApplicationPropertiesService applicationPropertiesService;
    private final BranchModelDao branchModelDao;
    private final BranchRestrictionScopeHelper branchRestrictionScopeHelper;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final RefService refService;
    private final RepositoryService repositoryService;
    private final ScopeValidationService scopeValidationService;

    public DefaultBranchModelService(ActiveObjects ao, ApplicationPropertiesService applicationPropertiesService, BranchModelDao branchModelDao, BranchRestrictionScopeHelper branchRestrictionScopeHelper, I18nService i18nService, EventPublisher eventPublisher, RefService refService, RepositoryService repositoryService, ScopeValidationService scopeValidationService) {
        this.ao = ao;
        this.applicationPropertiesService = applicationPropertiesService;
        this.branchModelDao = branchModelDao;
        this.branchRestrictionScopeHelper = branchRestrictionScopeHelper;
        this.i18nService = i18nService;
        this.eventPublisher = eventPublisher;
        this.refService = refService;
        this.repositoryService = repositoryService;
        this.scopeValidationService = scopeValidationService;
    }

    @Override
    public void deleteConfiguration(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        if (scope.getType() != ScopeType.REPOSITORY) {
            throw new IllegalArgumentException(String.format("The branch model can not be deleted at a %s level scope.", scope.getType()));
        }
        this.scopeValidationService.validateAdminPermission(scope, "bitbucket.branchmodel.error.invalidscope");
        this.branchRestrictionScopeHelper.validateNotRestricted(scope, "bitbucket.branchmodel.error.deletion.restricted");
        this.ao.executeInTransaction(() -> {
            this.branchModelDao.delete(scope);
            return null;
        });
        this.eventPublisher.publish((Object)new BranchModelConfigurationDeletedEvent(this, (Repository)scope.accept((ScopeVisitor)new ScopeVisitor<Repository>(this){

            public Repository visit(@Nonnull RepositoryScope scope) {
                return scope.getRepository();
            }
        })));
    }

    @Override
    @Nonnull
    public BranchModelConfiguration getConfiguration(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        BranchRestrictionScopeHelper.validateScopeType(scope, String.format("The branch model can not be configured at a %s level scope.", scope.getType()));
        this.validateNotPersonalProject(scope);
        this.scopeValidationService.validateAdminPermission(scope, "bitbucket.branchmodel.error.invalidscope");
        Scope unrestrictedScope = this.branchRestrictionScopeHelper.getUnrestrictedScope(scope);
        BranchModelConfiguration configuration = this.branchModelDao.get(unrestrictedScope).orElseGet(() -> (BranchModelConfiguration)unrestrictedScope.accept((ScopeVisitor)new ScopeVisitor<BranchModelConfiguration>(){

            public BranchModelConfiguration visit(@Nonnull ProjectScope projectScope) {
                return DefaultBranchModelService.this.createDefaultConfiguration(projectScope.getProject());
            }

            public BranchModelConfiguration visit(@Nonnull RepositoryScope repositoryScope) {
                return DefaultBranchModelService.this.getOrCreateProjectConfiguration(repositoryScope.getRepository());
            }
        }));
        return this.addI18nedDisplayNames(configuration);
    }

    @Override
    @Nonnull
    public BranchModelConfiguration getDefaultConfiguration(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        BranchRestrictionScopeHelper.validateScopeType(scope, String.format("The branch model can not be configured at a %s level scope.", scope.getType()));
        this.validateNotPersonalProject(scope);
        return ((SimpleBranchModelConfiguration.Builder)((SimpleBranchModelConfiguration.Builder)((SimpleBranchModelConfiguration.Builder)((SimpleBranchModelConfiguration.Builder)((SimpleBranchModelConfiguration.Builder)new SimpleBranchModelConfiguration.Builder(scope).development(new SimpleBranchConfiguration(null, true))).enabledType(InternalBranchTypes.BUGFIX.getId(), InternalBranchTypes.BUGFIX.getDefaultPrefix())).enabledType(InternalBranchTypes.FEATURE.getId(), InternalBranchTypes.FEATURE.getDefaultPrefix())).enabledType(InternalBranchTypes.HOTFIX.getId(), InternalBranchTypes.HOTFIX.getDefaultPrefix())).enabledType(InternalBranchTypes.RELEASE.getId(), InternalBranchTypes.RELEASE.getDefaultPrefix())).build();
    }

    @Override
    @Nonnull
    public BranchModel getModel(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        if (this.repositoryService.isEmpty(repository)) {
            throw new EmptyRepositoryException(this.i18nService.createKeyedMessage("bitbucket.branchmodel.error.emptyrepository", new Object[]{repository}));
        }
        Scope unrestrictedScope = this.branchRestrictionScopeHelper.getUnrestrictedScope((Scope)Scopes.repository((Repository)repository));
        return (BranchModel)this.ao.executeInTransaction(() -> {
            BranchModelConfiguration configuration = this.branchModelDao.get(unrestrictedScope).orElseGet(() -> (BranchModelConfiguration)unrestrictedScope.accept((ScopeVisitor)new ScopeVisitor<BranchModelConfiguration>(){

                public BranchModelConfiguration visit(@Nonnull ProjectScope projectScope) {
                    return DefaultBranchModelService.this.createDefaultConfiguration(projectScope.getProject());
                }

                public BranchModelConfiguration visit(@Nonnull RepositoryScope repositoryScope) {
                    return DefaultBranchModelService.this.getOrCreateProjectConfiguration(repositoryScope.getRepository());
                }
            }));
            return this.toBranchModel(configuration, repository);
        });
    }

    @EventListener
    public void onProjectCreated(@Nonnull ProjectCreatedEvent event) {
        Objects.requireNonNull(event, "event");
        this.ao.executeInTransaction(() -> {
            event.getProject().accept((ProjectVisitor)new ProjectVisitor<Void>(){

                public Void visit(@Nonnull Project project) {
                    DefaultBranchModelService.this.createDefaultConfiguration(project);
                    return null;
                }

                public Void visit(@Nonnull PersonalProject project) {
                    return null;
                }
            });
            return null;
        });
    }

    @EventListener
    public void onProjectDeletionRequested(@Nonnull ProjectDeletionRequestedEvent event) {
        Objects.requireNonNull(event, "event");
        if (!event.isCanceled()) {
            this.branchModelDao.delete((Scope)Scopes.project((Project)event.getProject()));
        }
    }

    @EventListener
    public void onRepositoryDeletionRequested(@Nonnull RepositoryDeletionRequestedEvent event) {
        Objects.requireNonNull(event, "event");
        if (!event.isCanceled()) {
            this.branchModelDao.delete((Scope)Scopes.repository((Repository)event.getRepository()));
        }
    }

    @Override
    @Nonnull
    public BranchModelConfiguration updateConfiguration(@Nonnull BranchModelConfigurationRequest request) {
        Objects.requireNonNull(request, "request");
        Scope scope = request.getScope();
        BranchRestrictionScopeHelper.validateScopeType(scope, String.format("The branch model can not be configured at a %s level scope.", scope.getType()));
        this.validateNotPersonalProject(scope);
        this.scopeValidationService.validateAdminPermission(scope, "bitbucket.branchmodel.error.invalidscope");
        this.branchRestrictionScopeHelper.validateNotRestricted(scope, "bitbucket.branchmodel.error.update.restricted");
        this.validate(scope, request);
        return (BranchModelConfiguration)this.ao.executeInTransaction(() -> {
            BranchModelConfiguration configuration = this.update(request, scope);
            return this.addI18nedDisplayNames(configuration);
        });
    }

    private BranchModelConfiguration addI18nedDisplayNames(BranchModelConfiguration originalModel) {
        ImmutableSet.Builder i18nedTypes = ImmutableSet.builder();
        for (BranchTypeConfiguration originalType : originalModel.getTypes()) {
            InternalBranchTypes internalType = InternalBranchTypes.forId(originalType.getId());
            i18nedTypes.add((Object)new SimpleBranchTypeConfiguration(internalType.getType(), internalType.getDisplayName(this.i18nService), originalType.isEnabled(), originalType.getPrefix()));
        }
        return ((SimpleBranchModelConfiguration.Builder)new SimpleBranchModelConfiguration.Builder(originalModel).types((Iterable)i18nedTypes.build())).build();
    }

    private BranchModelConfiguration createDefaultConfiguration(Project project) {
        ProjectScope scope = Scopes.project((Project)project);
        return this.update(new BranchModelConfigurationRequest.Builder(this.getDefaultConfiguration((Scope)scope)).build(), (Scope)scope);
    }

    private String getBranchI18nName(String branchId) {
        return this.i18nService.getMessage("bitbucket.branchmodel." + branchId, new Object[0]);
    }

    private int getBranchPrefixLimit() {
        return this.applicationPropertiesService.getPluginProperty(PROP_PREFIX_MAX_LENGTH, 30);
    }

    private Branch getDevelopmentBranch(BranchModelConfiguration configuration, Repository repository) {
        if (configuration.getDevelopment().isUseDefault()) {
            return this.refService.getDefaultBranch(repository);
        }
        Ref ref = this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(configuration.getDevelopment().getRefId()).type((RefType)StandardRefType.BRANCH).build());
        if (this.isNotBranch(ref)) {
            log.debug("Ref {} stored as development branch for repository {} does not resolve to a branch", (Object)configuration.getDevelopment().getRefId(), (Object)repository);
            return this.refService.getDefaultBranch(repository);
        }
        return (Branch)ref;
    }

    private Set<InternalBranchType> getEffectiveTypes(BranchModelConfiguration model) {
        ImmutableSet.Builder types = ImmutableSet.builder();
        for (BranchTypeConfiguration typeConfiguration : model.getTypes()) {
            if (!typeConfiguration.isEnabled()) continue;
            InternalBranchTypes internalType = InternalBranchTypes.forId(typeConfiguration.getId());
            types.add((Object)new SimpleInternalBranchType(internalType.getType(), internalType.getDisplayName(this.i18nService), typeConfiguration.getPrefix()));
        }
        return types.build();
    }

    private List<BranchTypeConfiguration> getEnabledTypes(BranchModelConfigurationRequest updateRequest) {
        return ImmutableList.copyOf((Collection)Sets.filter(updateRequest.getTypes(), BranchTypeConfiguration::isEnabled));
    }

    private BranchModelConfiguration getOrCreateProjectConfiguration(final @Nonnull Repository repository) {
        return this.branchModelDao.get((Scope)Scopes.project((Project)repository.getProject())).orElseGet(() -> (BranchModelConfiguration)repository.getProject().accept((ProjectVisitor)new ProjectVisitor<BranchModelConfiguration>(){

            public BranchModelConfiguration visit(@Nonnull Project project) {
                return DefaultBranchModelService.this.createDefaultConfiguration(project);
            }

            public BranchModelConfiguration visit(@Nonnull PersonalProject project) {
                return DefaultBranchModelService.this.getDefaultConfiguration((Scope)Scopes.repository((Repository)repository));
            }
        }));
    }

    private Branch getProductionBranch(BranchModelConfiguration configuration, Repository repository) {
        if (configuration.getProduction() == null) {
            return null;
        }
        if (configuration.getProduction().isUseDefault()) {
            return this.refService.getDefaultBranch(repository);
        }
        Ref ref = this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(configuration.getProduction().getRefId()).type((RefType)StandardRefType.BRANCH).build());
        if (this.isNotBranch(ref)) {
            log.debug("Ref {} stored as production branch for repository {} does not resolve to a branch", (Object)configuration.getProduction().getRefId(), (Object)repository);
            return null;
        }
        return (Branch)ref;
    }

    private String getVersionComponentSeparators() {
        return this.applicationPropertiesService.getPluginProperty(PROP_VERSION_COMPONENT_SEPARATOR, DEFAULT_VERSION_COMPONENT_SEPARATOR);
    }

    private boolean isNotBranch(Ref ref) {
        return ref == null || !Branch.class.isInstance(ref);
    }

    private BranchModel toBranchModel(BranchModelConfiguration configuration, Repository repository) {
        Set<BranchType> types = this.getEffectiveTypes(configuration);
        return new SimpleBranchModel.Builder(configuration.getScope()).development(this.getDevelopmentBranch(configuration, repository)).production(this.getProductionBranch(configuration, repository)).types(types).classifier(new PrefixBranchClassifier(this.refService, repository, types)).versionComponentSeparators(this.getVersionComponentSeparators()).build();
    }

    private BranchModelConfiguration update(BranchModelConfigurationRequest request, Scope scope) {
        return this.branchModelDao.get(scope).map(existingConfig -> {
            BranchModelConfiguration configuration = this.branchModelDao.update(request);
            this.eventPublisher.publish((Object)new BranchModelConfigurationUpdatedEvent(this, configuration, (BranchModelConfiguration)existingConfig));
            return configuration;
        }).orElseGet(() -> {
            BranchModelConfiguration configuration = this.branchModelDao.create(request);
            this.eventPublisher.publish((Object)new BranchModelConfigurationCreatedEvent(this, configuration));
            return configuration;
        });
    }

    private void validate(BranchModelConfigurationRequest updateRequest) {
        this.validateBranchConfiguration(updateRequest.getDevelopment(), DEVELOPMENT_ID);
        if (updateRequest.getProduction() != null) {
            this.validateBranchConfiguration(updateRequest.getProduction(), PRODUCTION_ID);
        }
        this.validatePrefixes(updateRequest);
    }

    private void validate(Repository repository, BranchModelConfigurationRequest updateRequest) {
        this.validateDevelopment(repository, updateRequest);
        this.validateProduction(repository, updateRequest);
        this.validatePrefixes(updateRequest);
    }

    private void validate(Scope scope, final BranchModelConfigurationRequest request) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope projectScope) {
                DefaultBranchModelService.this.validate(request);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                DefaultBranchModelService.this.validate(repositoryScope.getRepository(), request);
                return null;
            }
        });
    }

    private void validateBranchConfiguration(Repository repository, BranchConfiguration config, String branchTypeId) {
        this.validateBranchConfiguration(config, branchTypeId);
        if (!config.isUseDefault() && StringUtils.isNotEmpty((CharSequence)config.getRefId())) {
            this.validateRefId(repository, config.getRefId(), branchTypeId);
        }
    }

    private void validateBranchConfiguration(BranchConfiguration config, String branchTypeId) {
        if (StringUtils.isEmpty((CharSequence)config.getRefId()) && !config.isUseDefault()) {
            throw new BranchModelConfigurationException(this.i18nService.createKeyedMessage("bitbucket.branchmodel.error.invalidBranchConfiguration", new Object[]{this.getBranchI18nName(branchTypeId)}), branchTypeId, new String[0]);
        }
    }

    private void validateDevelopment(Repository repository, BranchModelConfigurationRequest updateRequest) {
        this.validateBranchConfiguration(repository, updateRequest.getDevelopment(), DEVELOPMENT_ID);
    }

    private void validateNoOverlap(BranchTypeConfiguration first, BranchTypeConfiguration second) {
        String secondPrefix;
        String firstPrefix = first.getPrefix();
        if (firstPrefix.startsWith(secondPrefix = second.getPrefix()) || secondPrefix.startsWith(firstPrefix)) {
            throw new BranchModelConfigurationException(this.i18nService.createKeyedMessage("bitbucket.branchmodel.error.prefixoverlap", new Object[]{firstPrefix, secondPrefix}), first.getId(), second.getId());
        }
    }

    private void validateNotPersonalProject(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                if (scope.getProject().getType() == ProjectType.PERSONAL) {
                    throw new ArgumentValidationException(DefaultBranchModelService.this.i18nService.createKeyedMessage("bitbucket.branchmodel.error.personalproject", new Object[0]));
                }
                return null;
            }
        });
    }

    private void validatePrefixLength(BranchTypeConfiguration typeConfiguration) {
        int prefixMaxLength = this.getBranchPrefixLimit();
        if (typeConfiguration.getPrefix().length() > prefixMaxLength) {
            throw new BranchModelConfigurationException(this.i18nService.createKeyedMessage("bitbucket.branchmodel.error.prefixtoolong", new Object[]{typeConfiguration.getPrefix(), prefixMaxLength}), typeConfiguration.getId(), new String[0]);
        }
    }

    private void validatePrefixNonEmpty(BranchTypeConfiguration typeConfiguration) {
        if (StringUtils.isBlank((CharSequence)typeConfiguration.getPrefix())) {
            throw new BranchModelConfigurationException(this.i18nService.createKeyedMessage("bitbucket.branchmodel.error.emptyprefix", new Object[0]), typeConfiguration.getId(), new String[0]);
        }
    }

    private void validatePrefixes(BranchModelConfigurationRequest updateRequest) {
        List<BranchTypeConfiguration> enabledTypes = this.getEnabledTypes(updateRequest);
        for (BranchTypeConfiguration typeConfiguration : enabledTypes) {
            this.validatePrefixNonEmpty(typeConfiguration);
            this.validatePrefixLength(typeConfiguration);
        }
        for (int i = 0; i < enabledTypes.size(); ++i) {
            for (int j = i + 1; j < enabledTypes.size(); ++j) {
                this.validateNoOverlap(enabledTypes.get(i), enabledTypes.get(j));
            }
        }
    }

    private void validateProduction(Repository repository, BranchModelConfigurationRequest updateRequest) {
        if (updateRequest.getProduction() != null) {
            this.validateBranchConfiguration(repository, updateRequest.getProduction(), PRODUCTION_ID);
        }
    }

    private void validateRefId(Repository repository, String refId, String branchTypeId) {
        if (this.isNotBranch(this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(refId).build()))) {
            throw new InvalidRefNameException(this.i18nService.createKeyedMessage(String.format("bitbucket.branchmodel.error.%s.invalidBranchId", branchTypeId), new Object[]{refId}), refId);
        }
    }
}

