/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model;

import com.atlassian.bitbucket.branch.model.BranchType;
import com.atlassian.bitbucket.branch.model.BranchTypes;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.branch.model.InternalBranchType;
import jakarta.annotation.Nonnull;
import java.util.Objects;

class InternalBranchTypes {
    static final InternalBranchTypes BUGFIX = InternalBranchTypes.forType(BranchTypes.BUGFIX);
    static final InternalBranchTypes FEATURE = InternalBranchTypes.forType(BranchTypes.FEATURE);
    static final InternalBranchTypes HOTFIX = InternalBranchTypes.forType(BranchTypes.HOTFIX);
    static final InternalBranchTypes RELEASE = InternalBranchTypes.forType(BranchTypes.RELEASE);
    private static final String I18N_PREFIX = "bitbucket.branchmodel.type.";
    private final BranchTypes type;

    private InternalBranchTypes(@Nonnull BranchTypes type) {
        this.type = Objects.requireNonNull(type, "type");
    }

    static InternalBranchType asInternalBranchType(@Nonnull BranchType branchType) {
        Objects.requireNonNull(branchType, "branchType");
        if (!InternalBranchType.class.isInstance(branchType)) {
            throw new ClassCastException("Unexpected BranchType implementation that is not an InternalBranchType: " + branchType.getClass().getName());
        }
        return (InternalBranchType)branchType;
    }

    static InternalBranchTypes forId(@Nonnull String id) {
        return InternalBranchTypes.forType(BranchTypes.forId(id));
    }

    static InternalBranchTypes forType(@Nonnull BranchTypes type) {
        return new InternalBranchTypes(type);
    }

    BranchTypes getType() {
        return this.type;
    }

    String getId() {
        return this.type.getId();
    }

    String getDisplayName(@Nonnull I18nService i18nService) {
        return i18nService.getMessage(I18N_PREFIX + this.type.getId(), new Object[0]);
    }

    String getDefaultPrefix() {
        return this.getId().toLowerCase() + "/";
    }
}

