/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model;

import com.atlassian.bitbucket.branch.model.BranchClassifier;
import com.atlassian.bitbucket.branch.model.BranchType;
import com.atlassian.bitbucket.internal.branch.model.InternalBranchType;
import com.atlassian.bitbucket.internal.branch.model.InternalBranchTypes;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefOrder;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryBranchesRequest;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class PrefixBranchClassifier
implements BranchClassifier {
    private static final int BRANCHES_PER_PAGE = 1000;
    private final RefService refService;
    private final Repository repository;
    private final Iterable<InternalBranchType> types;

    public PrefixBranchClassifier(@Nonnull RefService refService, @Nonnull Repository repository, @Nonnull Iterable<InternalBranchType> types) {
        this.refService = Objects.requireNonNull(refService, "refService");
        this.repository = Objects.requireNonNull(repository, "repository");
        this.types = Objects.requireNonNull(types, "types");
    }

    @Override
    @Nullable
    public InternalBranchType getType(@Nonnull MinimalRef branch) {
        Objects.requireNonNull(branch, "branch");
        return (InternalBranchType)Iterables.find(this.types, input -> branch.getDisplayId().startsWith(input.getPrefix()), null);
    }

    @Override
    @Nonnull
    public Iterable<Branch> getAllBranchesByType(final @Nonnull BranchType branchType) {
        return new PagedIterable((PageProvider)new PageProvider<Branch>(){

            public Page<Branch> get(PageRequest request) {
                return PrefixBranchClassifier.this.getBranchesByType(branchType, request);
            }
        }, 1000);
    }

    @Override
    @Nonnull
    public Page<Branch> getBranchesByType(@Nonnull BranchType branchType, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(branchType, "branchType");
        Objects.requireNonNull(pageRequest, "pageRequest");
        if (!Iterables.contains(this.types, (Object)branchType)) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return this.getPageForType(branchType, pageRequest);
    }

    private Page<Branch> getPageForType(BranchType branchType, PageRequest pageRequest) {
        final InternalBranchType internalBranchType = InternalBranchTypes.asInternalBranchType(branchType);
        PageProvider<Branch> branchesProvider = new PageProvider<Branch>(){

            public Page<Branch> get(PageRequest request) {
                return PrefixBranchClassifier.this.refService.getBranches(((RepositoryBranchesRequest.Builder)((RepositoryBranchesRequest.Builder)new RepositoryBranchesRequest.Builder(PrefixBranchClassifier.this.repository).filterText(internalBranchType.getPrefix())).order(RefOrder.ALPHABETICAL)).build(), request);
            }
        };
        Predicate<MinimalRef> startsWithPrefix = ref -> StringUtils.startsWith((CharSequence)ref.getDisplayId(), (CharSequence)internalBranchType.getPrefix());
        return PageUtils.filterPages((PageProvider)branchesProvider, startsWithPrefix, (PageRequest)pageRequest);
    }
}

