/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model;

import com.atlassian.bitbucket.branch.model.BranchClassifier;
import com.atlassian.bitbucket.branch.model.BranchType;
import com.atlassian.bitbucket.branch.model.BranchTypes;
import com.atlassian.bitbucket.internal.branch.model.BranchModelGraphBuilder;
import com.atlassian.bitbucket.internal.branch.model.BranchModelNode;
import com.atlassian.bitbucket.internal.branch.model.InternalBranchModel;
import com.atlassian.bitbucket.internal.branch.model.InternalBranchType;
import com.atlassian.bitbucket.internal.branch.model.InternalBranchTypes;
import com.atlassian.bitbucket.internal.branch.model.version.VersionedBranch;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.util.MoreStreams;
import com.google.common.collect.ImmutableSortedSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBranchModel
implements InternalBranchModel {
    private static final Logger log = LoggerFactory.getLogger(SimpleBranchModel.class);
    private final BranchClassifier classifier;
    private final Branch development;
    private final Branch production;
    private final Scope scope;
    private final Set<BranchType> types;
    private final String versionComponentSeparators;

    private SimpleBranchModel(Builder builder) {
        this.classifier = Objects.requireNonNull(builder.classifier, "classifier");
        this.development = Objects.requireNonNull(builder.development, "development");
        this.production = builder.production;
        this.scope = Objects.requireNonNull(builder.scope, "scope");
        this.types = builder.types.build();
        this.versionComponentSeparators = Objects.requireNonNull(builder.versionComponentSeparators, "versionComponentSeparators");
    }

    @Override
    @Nonnull
    public BranchClassifier getClassifier() {
        return this.classifier;
    }

    @Override
    @Nonnull
    public Branch getDevelopment() {
        return this.development;
    }

    @Override
    @Nullable
    public Branch getProduction() {
        return this.production;
    }

    @Override
    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    @Override
    @Nonnull
    public Set<BranchType> getTypes() {
        return this.types;
    }

    @Override
    @Nonnull
    public BranchModelNode getMergePath(@Nonnull Branch branch) {
        BranchType type = this.classifier.getType((MinimalRef)branch);
        LinkedHashSet<Branch> branches = new LinkedHashSet<Branch>();
        branches.add(branch);
        if (this.shouldCascadingMerge(branch, type)) {
            if (this.isRelease(type)) {
                InternalBranchType branchType = InternalBranchTypes.asInternalBranchType(type);
                Function<Branch, Optional<VersionedBranch>> toVersionedBranch = VersionedBranch.fromBranch(branchType.getPrefix(), this.versionComponentSeparators);
                Optional<VersionedBranch> start = toVersionedBranch.apply(branch);
                if (start.isPresent()) {
                    MoreStreams.streamIterable(this.classifier.getAllBranchesByType(type)).flatMap(b -> ((Optional)toVersionedBranch.apply((Branch)b)).map(Stream::of).orElse(Stream.empty())).filter(start.get().isGreater()).sorted().map(VersionedBranch.TO_BRANCH).forEach(branches::add);
                } else {
                    log.debug("Release branch '{}' doesn't have a valid version, not merging to any other release branch", (Object)branch.getDisplayId());
                }
            }
            branches.add(this.development);
        }
        return BranchModelGraphBuilder.forSinglePath(branches);
    }

    private boolean isProduction(Branch branch) {
        return this.production != null && this.production.equals((Object)branch);
    }

    private boolean isRelease(BranchType type) {
        return type != null && BranchTypes.RELEASE.getId().equals(type.getId());
    }

    private boolean shouldCascadingMerge(Branch branch, BranchType type) {
        return this.isProduction(branch) || this.isRelease(type);
    }

    public static class Builder {
        private final Scope scope;
        private final ImmutableSortedSet.Builder<BranchType> types = new ImmutableSortedSet.Builder(BranchTypes.DEFAULT_ORDER);
        private BranchClassifier classifier;
        private Branch development;
        private Branch production;
        private String versionComponentSeparators;

        public Builder(@Nonnull Scope scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
        }

        @Nonnull
        public Builder classifier(@Nonnull BranchClassifier classifier) {
            this.classifier = Objects.requireNonNull(classifier, "classifier");
            return this;
        }

        @Nonnull
        public Builder development(@Nonnull Branch development) {
            this.development = Objects.requireNonNull(development, "development");
            return this;
        }

        @Nonnull
        public Builder production(@Nullable Branch production) {
            this.production = production;
            return this;
        }

        @Nonnull
        public Builder types(@Nonnull Iterable<BranchType> types) {
            this.types.addAll(Objects.requireNonNull(types, "types"));
            return this;
        }

        @Nonnull
        public Builder versionComponentSeparators(@Nonnull String versionComponentSeparators) {
            this.versionComponentSeparators = Objects.requireNonNull(versionComponentSeparators, "versionComponentSeparators");
            return this;
        }

        public SimpleBranchModel build() {
            return new SimpleBranchModel(this);
        }
    }
}

