/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.configuration;

import com.atlassian.bitbucket.branch.model.BranchTypes;
import com.atlassian.bitbucket.branch.model.configuration.BranchConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchTypeConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.SimpleBranchTypeConfiguration;
import com.atlassian.bitbucket.scope.Scope;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class SimpleBranchModelConfiguration
implements BranchModelConfiguration {
    private final BranchConfiguration development;
    private final BranchConfiguration production;
    private final Scope scope;
    private final Set<BranchTypeConfiguration> types;

    protected SimpleBranchModelConfiguration(@Nonnull BranchConfiguration development, @Nullable BranchConfiguration production, @Nonnull Scope scope, @Nonnull Set<BranchTypeConfiguration> types) {
        this.development = Objects.requireNonNull(development, "development");
        this.production = production;
        this.scope = scope;
        this.types = ImmutableSet.copyOf((Collection)BranchTypes.DEFAULT_ORDER.immutableSortedCopy(types));
    }

    protected SimpleBranchModelConfiguration(@Nonnull AbstractBuilder<?> builder) {
        this(builder.development, builder.production, builder.scope, (Set<BranchTypeConfiguration>)ImmutableSet.copyOf(builder.types));
    }

    @Override
    @Nonnull
    public BranchConfiguration getDevelopment() {
        return this.development;
    }

    @Override
    @Nullable
    public BranchConfiguration getProduction() {
        return this.production;
    }

    @Override
    @Nonnull
    public Set<BranchTypeConfiguration> getTypes() {
        return this.types;
    }

    @Override
    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        protected final Set<BranchTypeConfiguration> types = Sets.newTreeSet(BranchTypes.DEFAULT_ORDER);
        protected BranchConfiguration development;
        protected BranchConfiguration production;
        private Scope scope;

        protected AbstractBuilder(BranchModelConfiguration original) {
            this.development = original.getDevelopment();
            this.production = original.getProduction();
            this.scope = original.getScope();
            this.types.addAll(original.getTypes());
        }

        public AbstractBuilder(@Nonnull Scope scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
        }

        @Nonnull
        public B development(@Nonnull BranchConfiguration development) {
            this.development = Objects.requireNonNull(development, "development");
            return this.self();
        }

        @Nonnull
        public B production(@Nullable BranchConfiguration production) {
            this.production = production;
            return this.self();
        }

        @Nonnull
        public B types(@Nonnull Iterable<BranchTypeConfiguration> values) {
            Objects.requireNonNull(values, "value");
            for (BranchTypeConfiguration type : values) {
                this.type(type);
            }
            return this.self();
        }

        @Nonnull
        public B types(@Nonnull BranchTypeConfiguration first, BranchTypeConfiguration ... rest) {
            Objects.requireNonNull(first, "first");
            Objects.requireNonNull(rest, "rest");
            this.types(Collections.singleton(first));
            return this.types(Arrays.asList(rest));
        }

        @Nonnull
        public B type(@Nonnull BranchTypeConfiguration value) {
            Objects.requireNonNull(value, "value");
            if (this.types.contains(value)) {
                this.types.remove(value);
            }
            this.types.add(value);
            return this.self();
        }

        @Nonnull
        public B type(@Nonnull String id, @Nullable String prefix, boolean enabled) {
            return this.type(new SimpleBranchTypeConfiguration(BranchTypes.forId(id), enabled, prefix));
        }

        @Nonnull
        public B enabledType(@Nonnull String id, @Nonnull String prefix) {
            return this.type(id, prefix, true);
        }

        protected abstract B self();
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        public Builder(@Nonnull Scope scope) {
            super(scope);
        }

        public Builder(BranchModelConfiguration original) {
            super(original);
        }

        public SimpleBranchModelConfiguration build() {
            return new SimpleBranchModelConfiguration(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

