/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.configuration.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfigurationRequest;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfigurationService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.branch.model.rest.RestBranchModelConfiguration;
import com.atlassian.bitbucket.internal.branch.model.rest.RestBranchTypeConfiguration;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.scope.Scope;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
public abstract class AbstractBranchModelConfigurationResource {
    protected static final String BRANCH_MODEL_CONFIG_PATH = "/branchmodel/configuration";
    private final BranchModelConfigurationService configurationService;
    private final I18nService i18nService;

    public AbstractBranchModelConfigurationResource(I18nService i18nService, BranchModelConfigurationService configurationService) {
        this.configurationService = configurationService;
        this.i18nService = i18nService;
    }

    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateBranchModelConfiguration(@Nullable RestBranchModelConfiguration configuration, @BeanParam ScopeResolver scopeResolver) {
        BranchModelConfigurationRequest request = this.createRequest(scopeResolver.getScope(), configuration);
        BranchModelConfiguration result = this.configurationService.updateConfiguration(request);
        return ResponseFactory.ok((Object)((Object)new RestBranchModelConfiguration(result))).build();
    }

    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteBranchModel(@BeanParam ScopeResolver scopeResolver) {
        this.configurationService.deleteConfiguration(scopeResolver.getScope());
        return ResponseFactory.noContent().build();
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getBranchModelConfiguration(@BeanParam ScopeResolver scopeResolver) {
        return ResponseFactory.ok((Object)((Object)new RestBranchModelConfiguration(this.configurationService.getConfiguration(scopeResolver.getScope())))).build();
    }

    private void addTypeTo(BranchModelConfigurationRequest.Builder requestBuilder, RestBranchTypeConfiguration typeConfig) {
        String typeId = this.getRequiredString(typeConfig, "id");
        try {
            requestBuilder.type(typeId, this.getRequiredString(typeConfig, "prefix"), typeConfig.isEnabled());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("types." + typeId, this.i18nService.getMessage("bitbucket.branchmodel.rest.error.invalidtype", new Object[]{e.getMessage()}));
        }
    }

    private BranchModelConfigurationRequest createRequest(Scope scope, RestBranchModelConfiguration entity) {
        if (entity == null) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.branchmodel.rest.error.invalidentity", new Object[0]));
        }
        if (entity.isUseDefault()) {
            return new BranchModelConfigurationRequest.Builder(this.configurationService.getDefaultConfiguration(scope)).build();
        }
        if (entity.getDevelopmentBranch() == null) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.branchmodel.rest.error.nodev", new Object[0]));
        }
        BranchModelConfigurationRequest.Builder requestBuilder = new BranchModelConfigurationRequest.Builder(scope).developmentRefId(entity.getDevelopmentBranch().getRefId()).useDefaultAsDevelopment(entity.getDevelopmentBranch().isUseDefault());
        if (entity.getProductionBranch() != null) {
            requestBuilder.productionRefId(entity.getProductionBranch().getRefId()).useDefaultAsProduction(entity.getProductionBranch().isUseDefault());
        }
        if (entity.getTypes() != null) {
            for (RestBranchTypeConfiguration typeConfig : entity.getTypes()) {
                this.addTypeTo(requestBuilder, typeConfig);
            }
        }
        return requestBuilder.build();
    }

    private String getRequiredString(RestBranchTypeConfiguration type, String key) {
        String value = (String)type.get(key);
        if (value == null) {
            throw new BadRequestException("types." + key, this.i18nService.getMessage("bitbucket.branchmodel.rest.error.valuerequired", new Object[]{key}));
        }
        return value;
    }
}

