/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.branch.model.BranchTypes;
import com.atlassian.bitbucket.branch.model.configuration.BranchConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfigurationRequest;
import com.atlassian.bitbucket.branch.model.configuration.BranchTypeConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.SimpleBranchTypeConfiguration;
import com.atlassian.bitbucket.internal.branch.model.configuration.SimpleBranchConfiguration;
import com.atlassian.bitbucket.internal.branch.model.configuration.SimpleBranchModelConfiguration;
import com.atlassian.bitbucket.internal.branch.model.dao.AoBranchTypeConfiguration;
import com.atlassian.bitbucket.internal.branch.model.dao.AoScopeBranchModelConfiguration;
import com.atlassian.bitbucket.internal.branch.model.dao.BranchModelDao;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;

public class AoBranchModelDao
extends AbstractAoDao
implements BranchModelDao {
    private static final int DELETE_ALL_MAX_SIZE = 1000;
    private static final String SCOPE_QUERY = "RESOURCE_ID = ? AND SCOPE_TYPE = ?";

    public AoBranchModelDao(@Nonnull ActiveObjects ao) {
        super(ao);
    }

    @Override
    @Nonnull
    public BranchModelConfiguration create(@Nonnull BranchModelConfigurationRequest request) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Scope scope = request.getScope();
        builder.put((Object)"SCOPE_TYPE", (Object)scope.getType());
        scope.getResourceId().ifPresent(resourceId -> builder.put((Object)"RESOURCE_ID", resourceId));
        this.maybePut((ImmutableMap.Builder<String, Object>)builder, "DEV_ID", request.getDevelopment().getRefId());
        this.maybePut((ImmutableMap.Builder<String, Object>)builder, "DEV_USE_DEFAULT", request.getDevelopment().isUseDefault());
        if (request.getProduction() != null) {
            this.maybePut((ImmutableMap.Builder<String, Object>)builder, "PROD_ID", request.getProduction().getRefId());
            this.maybePut((ImmutableMap.Builder<String, Object>)builder, "PROD_USE_DEFAULT", request.getProduction().isUseDefault());
        } else {
            this.maybePut((ImmutableMap.Builder<String, Object>)builder, "PROD_ID", null);
            this.maybePut((ImmutableMap.Builder<String, Object>)builder, "PROD_USE_DEFAULT", false);
        }
        AoScopeBranchModelConfiguration model = (AoScopeBranchModelConfiguration)this.ao.create(AoScopeBranchModelConfiguration.class, (Map)builder.build());
        for (BranchTypeConfiguration configuration : request.getTypes()) {
            this.ao.create(AoBranchTypeConfiguration.class, this.toAoTypeColumns(model, configuration));
        }
        return this.toBranchModelConfiguration(model, scope);
    }

    @Override
    public void delete(@Nonnull Scope scope) {
        scope.getResourceId().ifPresent(resourceId -> {
            AoScopeBranchModelConfiguration[] configurations = (AoScopeBranchModelConfiguration[])this.ao.find(AoScopeBranchModelConfiguration.class, SCOPE_QUERY, new Object[]{resourceId, scope.getType()});
            Arrays.stream(configurations).forEach(configuration -> this.ao.deleteWithSQL(AoBranchTypeConfiguration.class, "BM_ID = ?", new Object[]{configuration.getID()}));
            this.ao.delete((RawEntity[])configurations);
        });
    }

    @Override
    public void deleteAll(@Nonnull List<Integer> repositoryIds) {
        if (repositoryIds.isEmpty()) {
            return;
        }
        if (repositoryIds.size() > 1000) {
            throw new IllegalArgumentException("Repository ids cannot exceed 1000 entries.");
        }
        String query = "RESOURCE_ID" + " IN (" + StringUtils.repeat((String)"?", (String)",", (int)repositoryIds.size()) + ") AND " + "SCOPE_TYPE" + " = ?";
        Object[] parameters = repositoryIds.toArray(new Object[repositoryIds.size() + 1]);
        parameters[repositoryIds.size()] = ScopeType.REPOSITORY;
        AoScopeBranchModelConfiguration[] configurationResults = (AoScopeBranchModelConfiguration[])this.ao.find(AoScopeBranchModelConfiguration.class, Query.select().where(query, parameters));
        Arrays.stream(configurationResults).forEach(configuration -> this.ao.deleteWithSQL(AoBranchTypeConfiguration.class, "BM_ID = ?", new Object[]{configuration.getID()}));
        this.ao.delete((RawEntity[])configurationResults);
    }

    @Override
    @Nonnull
    public Optional<BranchModelConfiguration> get(@Nonnull Scope scope) {
        return this.getAoConfiguration(scope).map(configuration -> this.toBranchModelConfiguration((AoScopeBranchModelConfiguration)configuration, scope));
    }

    @Override
    @Nonnull
    public BranchModelConfiguration update(@Nonnull BranchModelConfigurationRequest request) {
        Scope scope = request.getScope();
        return this.toBranchModelConfiguration(this.getAoConfiguration(scope).map(existingConfig -> this.update(request, (AoScopeBranchModelConfiguration)existingConfig)).orElseThrow(() -> new IllegalStateException(String.format("A branch model configuration for scope %s with resourceId %s does not exist, so cannot be updated", scope.getType(), scope.getResourceId()))), scope);
    }

    private void applyUpdateToDevelopment(BranchModelConfigurationRequest updateRequest, AoScopeBranchModelConfiguration model) {
        model.setDevelopmentBranchId(updateRequest.getDevelopment().getRefId());
        model.setDevelopmentBranchUseDefault(updateRequest.getDevelopment().isUseDefault());
    }

    private void applyUpdateToProduction(BranchModelConfigurationRequest updateRequest, AoScopeBranchModelConfiguration model) {
        if (updateRequest.getProduction() != null) {
            model.setProductionBranchId(updateRequest.getProduction().getRefId());
            model.setProductionBranchUseDefault(updateRequest.getProduction().isUseDefault());
        } else {
            model.setProductionBranchId(null);
            model.setProductionBranchUseDefault(false);
        }
    }

    private void applyUpdateToTypes(BranchModelConfigurationRequest request, AoScopeBranchModelConfiguration aoModel, AoBranchTypeConfiguration[] aoTypes) {
        Map<String, BranchTypeConfiguration> typesMap = this.toTypesMap(request.getTypes());
        for (AoBranchTypeConfiguration aoTypeConfiguration : aoTypes) {
            BranchTypeConfiguration typeConfiguration = typesMap.remove(aoTypeConfiguration.getTypeId());
            if (typeConfiguration != null) {
                aoTypeConfiguration.setEnabled(typeConfiguration.isEnabled());
                aoTypeConfiguration.setPrefix(typeConfiguration.getPrefix());
            } else {
                aoTypeConfiguration.setEnabled(false);
                aoTypeConfiguration.setPrefix(null);
            }
            aoTypeConfiguration.save();
        }
        for (Map.Entry entry : typesMap.entrySet()) {
            this.ao.create(AoBranchTypeConfiguration.class, this.toAoTypeColumns(aoModel, (BranchTypeConfiguration)entry.getValue()));
        }
    }

    private AoBranchTypeConfiguration[] findAoTypes(int branchModelId) {
        return (AoBranchTypeConfiguration[])this.ao.find(AoBranchTypeConfiguration.class, Query.select().where("BM_ID = ?", new Object[]{branchModelId}));
    }

    private Optional<AoScopeBranchModelConfiguration> getAoConfiguration(@Nonnull Scope scope) {
        return scope.getResourceId().flatMap(resourceId -> {
            AoScopeBranchModelConfiguration[] configurations = (AoScopeBranchModelConfiguration[])this.ao.find(AoScopeBranchModelConfiguration.class, SCOPE_QUERY, new Object[]{resourceId, scope.getType()});
            return Arrays.stream(configurations).findFirst();
        });
    }

    private BranchConfiguration getDevelopmentBranchConfiguration(AoScopeBranchModelConfiguration aoBranchModel) {
        return new SimpleBranchConfiguration(aoBranchModel.getDevelopmentBranchId(), aoBranchModel.isDevelopmentBranchUseDefault());
    }

    private BranchConfiguration getProductionBranchConfiguration(AoScopeBranchModelConfiguration aoBranchModel) {
        if (StringUtils.isNotEmpty((CharSequence)aoBranchModel.getProductionBranchId()) || aoBranchModel.isProductionBranchUseDefault()) {
            return new SimpleBranchConfiguration(aoBranchModel.getProductionBranchId(), aoBranchModel.isProductionBranchUseDefault());
        }
        return null;
    }

    private void maybePut(ImmutableMap.Builder<String, Object> builder, String key, Object value) {
        if (value != null) {
            builder.put((Object)key, value);
        }
    }

    private Map<String, Object> toAoTypeColumns(AoScopeBranchModelConfiguration model, BranchTypeConfiguration config) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.maybePut((ImmutableMap.Builder<String, Object>)builder, "BM_ID", model.getID());
        this.maybePut((ImmutableMap.Builder<String, Object>)builder, "TYPE_ID", config.getId());
        this.maybePut((ImmutableMap.Builder<String, Object>)builder, "PREFIX", Strings.nullToEmpty((String)config.getPrefix()));
        this.maybePut((ImmutableMap.Builder<String, Object>)builder, "IS_ENABLED", config.isEnabled());
        return builder.build();
    }

    private SimpleBranchModelConfiguration toBranchModelConfiguration(AoScopeBranchModelConfiguration configuration, Scope scope) {
        AoBranchTypeConfiguration[] typeConfigurations = this.findAoTypes(configuration.getID());
        return ((SimpleBranchModelConfiguration.Builder)((SimpleBranchModelConfiguration.Builder)((SimpleBranchModelConfiguration.Builder)new SimpleBranchModelConfiguration.Builder(scope).development(this.getDevelopmentBranchConfiguration(configuration))).production(this.getProductionBranchConfiguration(configuration))).types(this.toTypes(typeConfigurations))).build();
    }

    private Set<BranchTypeConfiguration> toTypes(AoBranchTypeConfiguration[] aoTypes) {
        ImmutableSet.Builder types = ImmutableSet.builder();
        for (AoBranchTypeConfiguration aoTypeConfig : aoTypes) {
            BranchTypes type = BranchTypes.forId(aoTypeConfig.getTypeId());
            types.add((Object)new SimpleBranchTypeConfiguration(type, aoTypeConfig.isEnabled(), aoTypeConfig.getPrefix()));
        }
        return types.build();
    }

    private Map<String, BranchTypeConfiguration> toTypesMap(Set<BranchTypeConfiguration> types) {
        HashMap result = Maps.newHashMap();
        for (BranchTypeConfiguration configuration : types) {
            result.put(configuration.getId(), configuration);
        }
        return result;
    }

    private AoScopeBranchModelConfiguration update(@Nonnull BranchModelConfigurationRequest updateRequest, AoScopeBranchModelConfiguration branchModel) {
        this.applyUpdateToDevelopment(updateRequest, branchModel);
        this.applyUpdateToProduction(updateRequest, branchModel);
        this.applyUpdateToTypes(updateRequest, branchModel, this.findAoTypes(branchModel.getID()));
        branchModel.save();
        return branchModel;
    }
}

